/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.StringUtils;
import reborncore.common.util.Torus;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class FusionControlComputerBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public RebornInventory<FusionControlComputerBlockEntity> inventory;
    public int crafingTickTime = 0;
    public int neededPower = 0;
    public int size = 6;
    public int state = -1;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    FusionReactorRecipe currentRecipe = null;
    class_2960 currentRecipeID = null;
    boolean hasStartedCrafting = false;
    boolean checkNBTRecipe = false;
    long lastTick = -1L;

    public FusionControlComputerBlockEntity() {
        super(TRBlockEntities.FUSION_CONTROL_COMPUTER, "FusionControlComputer", -1, -1, TRContent.Machine.FUSION_CONTROL_COMPUTER.block, -1);
        this.checkOverfill = false;
        this.inventory = new RebornInventory(3, "FusionControlComputerBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 coil = TRContent.Machine.FUSION_COIL.block.method_9564();
        Torus.generate((class_2338)class_2338.field_10980, (int)this.size).forEach(pos -> writer.add(pos.method_10263(), pos.method_10264(), pos.method_10260(), coil));
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = 0;
        this.neededPower = 0;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(class_1799 stack, int slot, boolean tags) {
        if (stack.method_7960()) {
            return true;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)stack, (boolean)true, (boolean)tags)) {
            return stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914();
        }
        return false;
    }

    @Override
    public int getProgressScaled(int scale) {
        FusionReactorRecipe reactorRecipe = this.getCurrentRecipeFromID();
        if (this.crafingTickTime != 0 && reactorRecipe != null && reactorRecipe.getTime() != 0) {
            return this.crafingTickTime * scale / reactorRecipe.getTime();
        }
        return 0;
    }

    private void updateCurrentRecipe() {
        for (RebornRecipe recipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
            if (!this.validateRecipe((FusionReactorRecipe)recipe)) continue;
            this.currentRecipe = (FusionReactorRecipe)recipe;
            this.crafingTickTime = 0;
            this.neededPower = this.currentRecipe.getStartEnergy();
            this.hasStartedCrafting = false;
            break;
        }
    }

    private boolean validateRecipe(FusionReactorRecipe recipe) {
        return this.hasAllInputs(recipe) && this.canFitStack((class_1799)recipe.getOutputs().get(0), this.outputStackSlot, true);
    }

    private boolean hasAllInputs(RebornRecipe recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (RebornIngredient ingredient : recipeType.getRebornIngredients()) {
            boolean hasItem = false;
            if (ingredient.test(this.inventory.method_5438(this.topStackSlot)) || ingredient.test(this.inventory.method_5438(this.bottomStackSlot))) {
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private void useInput(int slot) {
        if (this.currentRecipe == null) {
            return;
        }
        for (RebornIngredient ingredient : this.currentRecipe.getRebornIngredients()) {
            if (!ingredient.test(this.inventory.method_5438(slot))) continue;
            this.inventory.shrinkSlot(slot, ingredient.getCount());
            break;
        }
    }

    @Override
    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.checkNBTRecipe) {
            this.checkNBTRecipe = false;
            for (RebornRecipe reactorRecipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
                if (!this.validateRecipe((FusionReactorRecipe)reactorRecipe)) continue;
                this.currentRecipe = (FusionReactorRecipe)reactorRecipe;
            }
        }
        if (this.lastTick == this.field_11863.method_8510()) {
            return;
        }
        this.lastTick = this.field_11863.method_8510();
        if (this.field_11863.method_8510() % 20L == 0L) {
            this.inventory.setChanged();
        }
        if (!this.isMultiblockValid()) {
            this.resetCrafter();
            return;
        }
        if (this.currentRecipe == null && this.inventory.hasChanged()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            class_1799 result;
            if (!this.hasStartedCrafting && !this.validateRecipe(this.currentRecipe)) {
                this.resetCrafter();
                this.inventory.resetChanged();
                return;
            }
            if (!this.hasStartedCrafting && this.canUseEnergy(this.currentRecipe.getStartEnergy())) {
                this.useEnergy(this.currentRecipe.getStartEnergy());
                this.hasStartedCrafting = true;
                this.useInput(this.topStackSlot);
                this.useInput(this.bottomStackSlot);
            }
            if (this.hasStartedCrafting && this.crafingTickTime < this.currentRecipe.getTime()) {
                if (this.currentRecipe.getPower() > 0) {
                    double power = (double)Math.abs(this.currentRecipe.getPower()) * this.getPowerMultiplier();
                    this.addEnergy(power);
                    this.powerChange = power;
                    ++this.crafingTickTime;
                } else if (this.canUseEnergy(this.currentRecipe.getPower())) {
                    this.setEnergy(this.getEnergy() - (double)this.currentRecipe.getPower());
                    ++this.crafingTickTime;
                }
            } else if (this.crafingTickTime >= this.currentRecipe.getTime() && this.canFitStack(result = (class_1799)this.currentRecipe.getOutputs().get(0), this.outputStackSlot, true)) {
                if (this.inventory.method_5438(this.outputStackSlot).method_7960()) {
                    this.inventory.method_5447(this.outputStackSlot, result.method_7972());
                } else {
                    this.inventory.shrinkSlot(this.outputStackSlot, -result.method_7947());
                }
                if (this.validateRecipe(this.currentRecipe)) {
                    this.crafingTickTime = 0;
                    this.useInput(this.topStackSlot);
                    this.useInput(this.bottomStackSlot);
                } else {
                    this.resetCrafter();
                }
            }
            this.method_5431();
        }
        this.inventory.resetChanged();
    }

    public double getPowerMultiplier() {
        double calc = 0.5 * Math.pow(this.size - 5, 1.8);
        return Math.max((double)Math.round(calc * 100.0) / 100.0, 1.0);
    }

    @Override
    public double getBaseMaxPower() {
        return Math.min((double)TechRebornConfig.fusionControlComputerMaxEnergy * this.getPowerMultiplier(), 2.147483647E9);
    }

    @Override
    public boolean canAcceptEnergy(class_2350 direction) {
        return direction != class_2350.field_11033 && direction != class_2350.field_11036;
    }

    @Override
    public boolean canProvideEnergy(class_2350 direction) {
        return direction == class_2350.field_11033 || direction == class_2350.field_11036;
    }

    @Override
    public double getBaseMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0.0;
        }
        return TechRebornConfig.fusionControlComputerMaxOutput;
    }

    @Override
    public double getBaseMaxInput() {
        if (this.hasStartedCrafting) {
            return 0.0;
        }
        return TechRebornConfig.fusionControlComputerMaxInput;
    }

    public void method_11014(class_2680 blockState, class_2487 tagCompound) {
        super.method_11014(blockState, tagCompound);
        this.crafingTickTime = tagCompound.method_10550("crafingTickTime");
        this.neededPower = tagCompound.method_10550("neededPower");
        this.hasStartedCrafting = tagCompound.method_10577("hasStartedCrafting");
        if (tagCompound.method_10545("hasActiveRecipe") && tagCompound.method_10577("hasActiveRecipe") && this.currentRecipe == null) {
            this.checkNBTRecipe = true;
        }
        if (tagCompound.method_10545("size")) {
            this.size = tagCompound.method_10550("size");
        }
        this.size = Math.min(this.size, TechRebornConfig.fusionControlComputerMaxCoilSize);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10569("crafingTickTime", this.crafingTickTime);
        tagCompound.method_10569("neededPower", this.neededPower);
        tagCompound.method_10556("hasStartedCrafting", this.hasStartedCrafting);
        tagCompound.method_10556("hasActiveRecipe", this.currentRecipe != null);
        tagCompound.method_10569("size", this.size);
        return tagCompound;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public RebornInventory<FusionControlComputerBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fusionreactor").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 34, 47).slot(1, 126, 47).outputSlot(2, 80, 47).syncEnergyValue().sync(this::getCrafingTickTime, this::setCrafingTickTime).sync(this::getSize, this::setSize).sync(this::getState, this::setState).sync(this::getNeededPower, this::setNeededPower).sync(this::getCurrentRecipeID, this::setCurrentRecipeID).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCrafingTickTime() {
        return this.crafingTickTime;
    }

    public void setCrafingTickTime(int crafingTickTime) {
        this.crafingTickTime = crafingTickTime;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void changeSize(int sizeDelta) {
        int newSize = this.size + sizeDelta;
        this.size = Math.max(6, Math.min(TechRebornConfig.fusionControlComputerMaxCoilSize, newSize));
    }

    public int getState() {
        if (this.currentRecipe == null) {
            return 0;
        }
        if (!this.hasStartedCrafting) {
            return 1;
        }
        return 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public class_2960 getCurrentRecipeID() {
        if (this.currentRecipe == null) {
            return new class_2960("null", "null");
        }
        return this.currentRecipe.method_8114();
    }

    public void setCurrentRecipeID(class_2960 currentRecipeID) {
        if (currentRecipeID.method_12832().equals("null")) {
            currentRecipeID = null;
        }
        this.currentRecipeID = currentRecipeID;
    }

    public FusionReactorRecipe getCurrentRecipeFromID() {
        if (this.currentRecipeID == null) {
            return null;
        }
        return ModRecipes.FUSION_REACTOR.getRecipes(this.field_11863).stream().filter(recipe -> recipe.method_8114().equals((Object)this.currentRecipeID)).findFirst().orElse(null);
    }

    public class_2561 getStateText() {
        if (this.state == -1) {
            return class_2585.field_24366;
        }
        if (this.state == 0) {
            return new class_2585("No recipe");
        }
        if (this.state == 1) {
            FusionReactorRecipe r = this.getCurrentRecipeFromID();
            if (r == null) {
                return new class_2585("Charging");
            }
            int percentage = this.percentage(r.getStartEnergy(), this.getEnergy());
            return new class_2585("Charging (").method_10852((class_2561)StringUtils.getPercentageText((int)percentage));
        }
        if (this.state == 2) {
            return new class_2585("Crafting");
        }
        return class_2585.field_24366;
    }

    private int percentage(double MaxValue, double CurrentValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }
}

