/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class RollingMachineBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private class_1715 craftCache;
    public RebornInventory<RollingMachineBlockEntity> inventory = new RebornInventory(12, "RollingMachineBlockEntity", 64, (MachineBaseBlockEntity)this);
    public boolean isRunning;
    public int tickTime;
    @Nonnull
    public class_1799 currentRecipeOutput;
    public RollingMachineRecipe currentRecipe;
    private final int outputSlot;
    public boolean locked = false;
    public int balanceSlot = 0;

    public RollingMachineBlockEntity() {
        super(TRBlockEntities.ROLLING_MACHINE);
        this.outputSlot = 9;
    }

    public double getBaseMaxPower() {
        return TechRebornConfig.rollingMachineMaxEnergy;
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return true;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return TechRebornConfig.rollingMachineMaxInput;
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        this.charge(10);
        class_1715 craftMatrix = this.getCraftingMatrix();
        this.currentRecipe = this.findMatchingRecipe(craftMatrix, this.field_11863);
        if (this.currentRecipe != null) {
            Optional<class_1715> balanceResult;
            this.setIsActive(true);
            if (this.field_11863.method_8510() % 2L == 0L && (balanceResult = this.balanceRecipe(craftMatrix)).isPresent()) {
                craftMatrix = balanceResult.get();
            }
            this.currentRecipeOutput = this.currentRecipe.method_8116((class_1263)craftMatrix);
        } else {
            this.currentRecipeOutput = class_1799.field_8037;
        }
        if (!this.currentRecipeOutput.method_7960() && this.canMake(craftMatrix)) {
            if (this.tickTime >= Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.currentRecipeOutput = this.findMatchingRecipeOutput(craftMatrix, this.field_11863);
                if (!this.currentRecipeOutput.method_7960()) {
                    boolean hasCrafted = false;
                    if (this.inventory.method_5438(this.outputSlot).method_7960()) {
                        this.inventory.method_5447(this.outputSlot, this.currentRecipeOutput.method_7972());
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else if (this.inventory.method_5438(this.outputSlot).method_7947() + this.currentRecipeOutput.method_7947() <= this.currentRecipeOutput.method_7914()) {
                        class_1799 stack = this.inventory.method_5438(this.outputSlot);
                        stack.method_7939(stack.method_7947() + this.currentRecipeOutput.method_7947());
                        this.inventory.method_5447(this.outputSlot, stack);
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else {
                        this.setIsActive(false);
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < craftMatrix.method_5439(); ++i) {
                            this.inventory.shrinkSlot(i, 1);
                        }
                        this.currentRecipeOutput = class_1799.field_8037;
                        this.currentRecipe = null;
                    }
                }
            }
        } else {
            this.tickTime = 0;
        }
        if (!this.currentRecipeOutput.method_7960()) {
            if (this.canUseEnergy(this.getEuPerTick(TechRebornConfig.rollingMachineEnergyPerTick)) && this.tickTime < Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1) && this.canMake(craftMatrix)) {
                this.useEnergy(this.getEuPerTick(TechRebornConfig.rollingMachineEnergyPerTick));
                ++this.tickTime;
            } else {
                this.setIsActive(false);
            }
        }
        if (this.currentRecipeOutput.method_7960()) {
            this.tickTime = 0;
            this.currentRecipe = null;
            this.setIsActive(this.canMake(this.getCraftingMatrix()));
        }
    }

    public void setIsActive(boolean active) {
        if (active == this.isRunning) {
            return;
        }
        this.isRunning = active;
        if (this.method_10997().method_8320(this.method_11016()).method_26204() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)this.method_10997().method_8320(this.method_11016()).method_26204();
            blockMachineBase.setActive(Boolean.valueOf(active), this.method_10997(), this.method_11016());
        }
        this.method_10997().method_8413(this.method_11016(), this.method_10997().method_8320(this.method_11016()), this.method_10997().method_8320(this.method_11016()), 3);
    }

    public Optional<class_1715> balanceRecipe(class_1715 craftCache) {
        class_1799 sourceStack;
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        if (this.field_11863.field_9236) {
            return Optional.empty();
        }
        if (!this.locked) {
            return Optional.empty();
        }
        if (craftCache.method_5442()) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.method_5439()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.method_5438(this.balanceSlot)).method_7960()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int s = 0; s < this.currentRecipe.method_8117().size(); ++s) {
            class_1799 stackInSlot = this.inventory.method_5438(s);
            class_1856 ingredient = (class_1856)this.currentRecipe.method_8117().get(s);
            if (ingredient == class_1856.field_9017 || !ingredient.method_8093(sourceStack)) continue;
            if (stackInSlot.method_7960()) {
                possibleSlots.add(s);
                continue;
            }
            if (stackInSlot.method_7909() != sourceStack.method_7909()) continue;
            possibleSlots.add(s);
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotEnvTyperubution = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int i = 0; i < split.length; ++i) {
                int required = split[i];
                if (slotEnvTyperubution.contains(required)) {
                    slotEnvTyperubution.remove(new Integer(required));
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            class_1799 slotStack = this.inventory.method_5438(slot.intValue());
            if (slotStack.method_7960()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.method_7947()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
        }
        if (bestSlot == null || (Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.method_7947() || this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7960() || !ItemUtils.isItemEqual((class_1799)sourceStack, (class_1799)this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.method_7934(1);
        this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7933(1);
        this.inventory.setChanged();
        return Optional.of(this.getCraftingMatrix());
    }

    private class_1715 getCraftingMatrix() {
        if (this.craftCache == null) {
            this.craftCache = new class_1715((class_1703)new RollingBEContainer(), 3, 3);
        }
        if (this.inventory.hasChanged()) {
            for (int i = 0; i < 9; ++i) {
                this.craftCache.method_5447(i, this.inventory.method_5438(i).method_7972());
            }
            this.inventory.resetChanged();
        }
        return this.craftCache;
    }

    public boolean canMake(class_1715 craftMatrix) {
        class_1799 stack = this.findMatchingRecipeOutput(craftMatrix, this.field_11863);
        if (this.locked) {
            for (int i = 0; i < craftMatrix.method_5439(); ++i) {
                class_1799 stack1 = craftMatrix.method_5438(i);
                if (stack1.method_7960() || stack1.method_7947() >= 2) continue;
                return false;
            }
        }
        if (stack.method_7960()) {
            return false;
        }
        class_1799 output = this.inventory.method_5438(this.outputSlot);
        if (output.method_7960()) {
            return true;
        }
        return ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true);
    }

    public List<RollingMachineRecipe> getAllRecipe(class_1937 world) {
        return ModRecipes.ROLLING_MACHINE.getRecipes(world);
    }

    public class_1799 findMatchingRecipeOutput(class_1715 inv, class_1937 world) {
        RollingMachineRecipe recipe = this.findMatchingRecipe(inv, world);
        if (recipe == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110();
    }

    public RollingMachineRecipe findMatchingRecipe(class_1715 inv, class_1937 world) {
        for (RollingMachineRecipe recipe : this.getAllRecipe(world)) {
            if (!recipe.method_8115((class_1263)inv, world)) continue;
            return recipe;
        }
        return null;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.ROLLING_MACHINE.getStack();
    }

    public void method_11014(class_2680 blockState, class_2487 tagCompound) {
        super.method_11014(blockState, tagCompound);
        this.isRunning = tagCompound.method_10577("isRunning");
        this.tickTime = tagCompound.method_10550("tickTime");
        this.locked = tagCompound.method_10577("locked");
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10556("isRunning", this.isRunning);
        tagCompound.method_10569("tickTime", this.tickTime);
        tagCompound.method_10556("locked", this.locked);
        return tagCompound;
    }

    public RebornInventory<RollingMachineBlockEntity> getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1) == 0) {
            return 0;
        }
        return this.tickTime * scale / Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1);
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("rollingmachine").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 30, 22).slot(1, 48, 22).slot(2, 66, 22).slot(3, 30, 40).slot(4, 48, 40).slot(5, 66, 40).slot(6, 30, 58).slot(7, 48, 58).slot(8, 66, 58).onCraft(inv -> this.inventory.method_5447(1, this.findMatchingRecipeOutput(this.getCraftingMatrix(), this.field_11863))).outputSlot(9, 124, 40).energySlot(10, 8, 70).syncEnergyValue().sync(this::getBurnTime, this::setBurnTime).sync(this::getLockedInt, this::setLockedInt).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0 && Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1) != 0) {
            return this.tickTime * scale / Math.max((int)((double)TechRebornConfig.rollingMachineRunTime * (1.0 - this.getSpeedMultiplier())), 1);
        }
        return 0;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    private static class RollingBEContainer
    extends class_1703 {
        protected RollingBEContainer() {
            super(null, 0);
        }

        public boolean method_7597(class_1657 entityplayer) {
            return true;
        }
    }
}

