/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.fluid;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.apache.commons.lang3.text.WordUtils;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.client.screen.builder.Syncable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidUtil;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.GenericFluidContainer;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.utils.FluidUtils;

public class TankUnitBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider,
BuiltScreenHandlerProvider {
    protected Tank tank;
    protected RebornInventory<TankUnitBaseBlockEntity> inventory = new RebornInventory(2, "TankInventory", 64, (MachineBaseBlockEntity)this);
    private TRContent.TankUnit type;

    public TankUnitBaseBlockEntity() {
        super(TRBlockEntities.TANK_UNIT);
    }

    public TankUnitBaseBlockEntity(TRContent.TankUnit type) {
        super(TRBlockEntities.TANK_UNIT);
        this.configureEntity(type);
    }

    private void configureEntity(TRContent.TankUnit type) {
        this.type = type;
        this.tank = new Tank("TankStorage", type.capacity, (MachineBaseBlockEntity)this);
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (FluidUtils.drainContainers((GenericFluidContainer<class_2350>)this.tank, this.inventory, 0, 1) || FluidUtils.fillContainers((GenericFluidContainer<class_2350>)this.tank, this.inventory, 0, 1, this.tank.getFluid())) {
            if (this.type == TRContent.TankUnit.CREATIVE && !this.tank.isEmpty() && !this.tank.isFull()) {
                this.tank.setFluidAmount(FluidValue.INFINITE);
            }
            this.syncWithAll();
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void method_11014(class_2680 blockState, class_2487 tagCompound) {
        super.method_11014(blockState, tagCompound);
        if (tagCompound.method_10545("unitType")) {
            this.type = TRContent.TankUnit.valueOf(tagCompound.method_10558("unitType"));
            this.configureEntity(this.type);
            this.tank.read(tagCompound);
        }
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10582("unitType", this.type.name());
        this.tank.write(tagCompound);
        return tagCompound;
    }

    public class_1799 getDropWithNBT() {
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        class_2487 blockEntity = new class_2487();
        this.method_11007(blockEntity);
        dropStack.method_7980(new class_2487());
        dropStack.method_7948().method_10566("blockEntity", (class_2520)blockEntity);
        return dropStack;
    }

    public RebornInventory<TankUnitBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            if (!this.tank.getFluidInstance().isEmpty()) {
                info.add((class_2561)new class_2585(String.valueOf(this.tank.getFluidAmount())).method_10852((class_2561)new class_2588("techreborn.tooltip.unit.divider")).method_27693(WordUtils.capitalize((String)FluidUtil.getFluidName((class_3611)this.tank.getFluid()))));
            } else {
                info.add((class_2561)new class_2588("techreborn.tooltip.unit.empty"));
            }
        }
        info.add((class_2561)new class_2588("techreborn.tooltip.unit.capacity").method_27692(class_124.field_1080).method_10852((class_2561)new class_2585(String.valueOf(this.tank.getCapacity())).method_27692(class_124.field_1065).method_27693(" (").method_27693(String.valueOf(this.tank.getCapacity().getRawValue() / 1000)).method_27693(")")));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("tank").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).fluidSlot(0, 100, 53).outputSlot(1, 140, 53).sync((Syncable)this.tank).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    @Nonnull
    public Tank getTank() {
        return this.tank;
    }

    @Deprecated
    public void setTank(Tank tank) {
        this.tank.setFluid(null, tank.getFluidInstance());
    }

    public class_1799 getToolDrop(class_1657 playerEntity) {
        return this.getDropWithNBT();
    }
}

