/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.WorldUtils;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class StorageUnitBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider,
BuiltScreenHandlerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public int storedAmount = 0;
    protected RebornInventory<StorageUnitBaseBlockEntity> inventory;
    private int maxCapacity;
    private class_1799 storeItemStack;
    private TRContent.StorageUnit type;
    private class_1799 lockedItemStack = class_1799.field_8037;

    public StorageUnitBaseBlockEntity() {
        super(TRBlockEntities.STORAGE_UNIT);
    }

    public StorageUnitBaseBlockEntity(TRContent.StorageUnit type) {
        super(TRBlockEntities.STORAGE_UNIT);
        this.configureEntity(type);
    }

    private void configureEntity(TRContent.StorageUnit type) {
        this.maxCapacity = type.capacity;
        this.storeItemStack = class_1799.field_8037;
        this.inventory = new RebornInventory(2, "ItemInventory", 64, (MachineBaseBlockEntity)this);
        this.type = type;
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.inventory.method_5438(0).method_7960() && !this.isFull()) {
            this.inventory.method_5447(0, this.processInput(this.inventory.method_5438(0)));
        }
        if (this.storeItemStack.method_7947() > 0 && this.inventory.method_5438(1).method_7947() < this.getStoredStack().method_7914()) {
            this.populateOutput();
        }
        if (this.type == TRContent.StorageUnit.CREATIVE && !this.isFull() && !this.method_5442()) {
            this.fillToCapacity();
        }
        if (this.inventory.hasChanged()) {
            this.syncWithAll();
            this.inventory.resetChanged();
        }
    }

    private void populateOutput() {
        class_1799 output = this.storeItemStack.method_7972();
        int outputSlotCount = this.inventory.method_5438(1).method_7947();
        output.method_7939(outputSlotCount);
        int amountToFill = this.getStoredStack().method_7914() - outputSlotCount;
        if (this.storeItemStack.method_7947() >= amountToFill) {
            this.storeItemStack.method_7934(amountToFill);
            if (this.storeItemStack.method_7960()) {
                this.storeItemStack = class_1799.field_8037;
            }
            output.method_7933(amountToFill);
        } else {
            output.method_7933(this.storeItemStack.method_7947());
            this.storeItemStack = class_1799.field_8037;
        }
        this.inventory.method_5447(1, output);
    }

    private void addStoredItemCount(int amount) {
        this.storeItemStack.method_7933(amount);
    }

    public class_1799 getStoredStack() {
        return this.storeItemStack.method_7960() ? this.inventory.method_5438(1) : this.storeItemStack;
    }

    public void setStoredStack(class_1799 itemStack) {
        this.storeItemStack = itemStack;
    }

    public class_1799 getDisplayedStack() {
        if (!this.isLocked()) {
            return this.getStoredStack();
        }
        return this.lockedItemStack;
    }

    public class_1799 getAll() {
        class_1799 returnStack = class_1799.field_8037;
        if (!this.method_5442()) {
            returnStack = this.getStoredStack().method_7972();
            returnStack.method_7939(this.getCurrentCapacity());
        }
        return returnStack;
    }

    public class_1799 processInput(class_1799 inputStack) {
        boolean isSameStack = this.isSameType(inputStack);
        if (this.storeItemStack == class_1799.field_8037 && (isSameStack || this.getCurrentCapacity() == 0 && !this.isLocked())) {
            this.storeItemStack = inputStack.method_7972();
            if (inputStack.method_7947() <= this.maxCapacity) {
                inputStack = class_1799.field_8037;
            } else {
                this.storeItemStack.method_7939(this.maxCapacity);
                inputStack.method_7934(this.maxCapacity);
            }
        } else if (isSameStack) {
            int reminder = this.maxCapacity - this.getCurrentCapacity();
            if (inputStack.method_7947() <= reminder) {
                this.addStoredItemCount(inputStack.method_7947());
                inputStack = class_1799.field_8037;
            } else {
                this.addStoredItemCount(reminder);
                inputStack.method_7934(reminder);
            }
        }
        this.inventory.setChanged();
        return inputStack;
    }

    public boolean isSameType(class_1799 inputStack) {
        if (this.isLocked()) {
            return ItemUtils.isItemEqual((class_1799)this.lockedItemStack, (class_1799)inputStack, (boolean)true, (boolean)true);
        }
        if (inputStack != class_1799.field_8037) {
            return ItemUtils.isItemEqual((class_1799)this.getStoredStack(), (class_1799)inputStack, (boolean)true, (boolean)true);
        }
        return false;
    }

    private void fillToCapacity() {
        this.storeItemStack = this.getStoredStack();
        this.storeItemStack.method_7939(this.maxCapacity);
        this.inventory.method_5447(1, class_1799.field_8037);
    }

    public boolean isFull() {
        return this.getCurrentCapacity() == this.maxCapacity;
    }

    public boolean method_5442() {
        return this.getCurrentCapacity() == 0;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return super.method_5492(index, stack, direction) && (this.method_5442() && !this.isLocked() || this.isSameType(stack));
    }

    public int getCurrentCapacity() {
        return this.storeItemStack.method_7947() + this.inventory.method_5438(1).method_7947();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void method_11014(class_2680 blockState, class_2487 tagCompound) {
        super.method_11014(blockState, tagCompound);
        if (tagCompound.method_10545("unitType")) {
            this.type = TRContent.StorageUnit.valueOf(tagCompound.method_10558("unitType"));
            this.configureEntity(this.type);
        } else {
            this.type = TRContent.StorageUnit.QUANTUM;
        }
        this.storeItemStack = class_1799.field_8037;
        if (tagCompound.method_10545("storedStack")) {
            this.storeItemStack = class_1799.method_7915((class_2487)tagCompound.method_10562("storedStack"));
        }
        if (!this.storeItemStack.method_7960()) {
            this.storeItemStack.method_7939(Math.min(tagCompound.method_10550("storedQuantity"), this.maxCapacity));
        }
        if (tagCompound.method_10545("totalStoredAmount")) {
            this.storedAmount = tagCompound.method_10550("totalStoredAmount");
        }
        if (tagCompound.method_10545("lockedItem")) {
            this.lockedItemStack = class_1799.method_7915((class_2487)tagCompound.method_10562("lockedItem"));
        }
        this.inventory.read(tagCompound);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10582("unitType", this.type.name());
        if (!this.storeItemStack.method_7960()) {
            class_1799 temp = this.storeItemStack.method_7972();
            if (this.storeItemStack.method_7947() > this.storeItemStack.method_7914()) {
                temp.method_7939(this.storeItemStack.method_7914());
            }
            tagCompound.method_10566("storedStack", (class_2520)temp.method_7953(new class_2487()));
            tagCompound.method_10569("storedQuantity", Math.min(this.storeItemStack.method_7947(), this.maxCapacity));
        } else {
            tagCompound.method_10569("storedQuantity", 0);
        }
        tagCompound.method_10569("totalStoredAmount", this.getCurrentCapacity());
        if (this.isLocked()) {
            tagCompound.method_10566("lockedItem", (class_2520)this.lockedItemStack.method_7953(new class_2487()));
        }
        this.inventory.write(tagCompound);
        return tagCompound;
    }

    public RebornInventory<StorageUnitBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return this.getDropWithNBT();
    }

    public class_1799 getDropWithNBT() {
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        class_2487 blockEntity = new class_2487();
        this.method_11007(blockEntity);
        dropStack.method_7980(new class_2487());
        dropStack.method_7969().method_10566("blockEntity", (class_2520)blockEntity);
        return dropStack;
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            if (!this.method_5442()) {
                info.add((class_2561)new class_2585(String.valueOf(this.getCurrentCapacity())).method_10852((class_2561)new class_2588("techreborn.tooltip.unit.divider")).method_10852(this.getStoredStack().method_7964()));
            } else {
                info.add((class_2561)new class_2588("techreborn.tooltip.unit.empty"));
            }
        }
        info.add((class_2561)new class_2588("techreborn.tooltip.unit.capacity").method_27692(class_124.field_1080).method_10852((class_2561)new class_2585(String.valueOf(this.getMaxCapacity())).method_27692(class_124.field_1065).method_27693(" items (").method_27693(String.valueOf(this.getMaxCapacity() / 64)).method_27693(")")));
    }

    public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
        super.onBreak(world, playerEntity, blockPos, blockState);
        if (this.type == TRContent.StorageUnit.CREATIVE) {
            this.inventory.method_5448();
            return;
        }
        if (this.storeItemStack != class_1799.field_8037) {
            if (this.storeItemStack.method_7914() == 64) {
                WorldUtils.dropItem((class_1799)this.storeItemStack, (class_1937)world, (class_2338)this.field_11867);
            } else {
                int size = this.storeItemStack.method_7914();
                for (int i = 0; i < this.storeItemStack.method_7947() / size; ++i) {
                    class_1799 toDrop = this.storeItemStack.method_7972();
                    toDrop.method_7939(size);
                    WorldUtils.dropItem((class_1799)toDrop, (class_1937)world, (class_2338)this.field_11867);
                }
                if (this.storeItemStack.method_7947() % size != 0) {
                    class_1799 toDrop = this.storeItemStack.method_7972();
                    toDrop.method_7939(this.storeItemStack.method_7947() % size);
                    WorldUtils.dropItem((class_1799)toDrop, (class_1937)world, (class_2338)this.field_11867);
                }
            }
        }
    }

    private int isLockedInt() {
        return this.isLocked() ? 1 : 0;
    }

    private void setLockedInt(int lockedInt) {
        this.setLocked(lockedInt == 1);
    }

    public boolean isLocked() {
        return this.lockedItemStack != class_1799.field_8037;
    }

    public void setLocked(boolean value) {
        if (this.isLocked() == value) {
            return;
        }
        class_1799 stack = this.getStoredStack().method_7972();
        stack.method_7939(1);
        this.lockedItemStack = value ? stack : class_1799.field_8037;
        this.syncWithAll();
    }

    public boolean canModifyLocking() {
        if (this.isLocked()) {
            return true;
        }
        return !this.method_5442();
    }

    public int getStoredAmount() {
        return this.getCurrentCapacity();
    }

    public void setStoredAmount(int storedAmount) {
        this.storedAmount = storedAmount;
    }

    public void setStoredStackFromNBT(class_2487 tag) {
        this.storeItemStack = class_1799.method_7915((class_2487)tag);
    }

    public class_2487 getStoredStackNBT() {
        class_2487 tag = new class_2487();
        this.getStoredStack().method_7953(tag);
        return tag;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 playerEntity) {
        return new ScreenHandlerBuilder("chest").player(playerEntity.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 100, 53).outputSlot(1, 140, 53).sync(this::isLockedInt, this::setLockedInt).sync(this::getStoredStackNBT, this::setStoredStackFromNBT).sync(this::getStoredAmount, this::setStoredAmount).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0 && this.isLocked()) {
            return ItemUtils.isItemEqual((class_1799)this.lockedItemStack, (class_1799)stack, (boolean)true, (boolean)true);
        }
        if (slot == 0 && !this.method_5442() && !this.isSameType(stack)) {
            return false;
        }
        return super.method_5437(slot, stack);
    }
}

