/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.libcd;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.cottonmc.libcd.api.CDSyntaxError;
import io.github.cottonmc.libcd.api.tweaker.util.TweakerUtils;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import reborncore.common.crafting.ingredient.FluidIngredient;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.ingredient.StackIngredient;
import reborncore.common.crafting.ingredient.TagIngredient;
import reborncore.common.crafting.ingredient.WrappedIngredient;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;

public class TRRecipeParser {
    public static RebornIngredient processIngredient(Object input) throws CDSyntaxError {
        if (input instanceof RebornIngredient) {
            return (RebornIngredient)input;
        }
        if (input instanceof class_1856) {
            return new WrappedIngredient((class_1856)input);
        }
        if (input instanceof String) {
            class_1799 stack;
            class_2960 id;
            String in = (String)input;
            Optional<Object> amount = Optional.empty();
            int atIndex = in.lastIndexOf(64);
            if (atIndex != -1 && in.lastIndexOf(125) < atIndex) {
                String count = in.substring(atIndex + 1);
                amount = Optional.of(Integer.parseInt(count));
                in = in.substring(0, atIndex);
            }
            if (in.indexOf(126) == 0) {
                id = new class_2960(in.substring(1));
                class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(id);
                if (fluid == class_3612.field_15906) {
                    throw new CDSyntaxError("Failed to get fluid for input: " + in);
                }
                return new FluidIngredient(fluid, Optional.empty(), amount);
            }
            if (in.indexOf(35) == 0) {
                id = new class_2960(in.substring(1));
                class_3494 itemTag = class_3489.method_15106().method_15193(id);
                if (itemTag == null) {
                    throw new CDSyntaxError("Failed to get item tag for input: " + in);
                }
                return new TagIngredient(id, class_3489.method_15106().method_15193(id), amount);
            }
            Optional<Object> tag = Optional.empty();
            boolean requireEmpty = false;
            if (in.contains("->")) {
                class_1799 readStack = TweakerUtils.INSTANCE.getSpecialStack(in);
                if (readStack.method_7960()) {
                    throw new CDSyntaxError("Failed to get special stack for input: " + in);
                }
                if (readStack.method_7985()) {
                    tag = Optional.of(readStack.method_7969());
                } else {
                    requireEmpty = true;
                }
                stack = readStack;
            } else {
                class_2960 id2;
                class_1792 item;
                int nbtIndex = in.indexOf(123);
                if (nbtIndex != -1) {
                    try {
                        String nbt = in.substring(nbtIndex);
                        in = in.substring(0, nbtIndex);
                        class_2522 reader = new class_2522(new StringReader(nbt));
                        class_2487 parsedTag = reader.method_10727();
                        if (parsedTag.isEmpty()) {
                            requireEmpty = true;
                        } else {
                            tag = Optional.of(reader.method_10727());
                        }
                    }
                    catch (CommandSyntaxException e) {
                        throw new CDSyntaxError(e.getMessage());
                    }
                }
                if ((item = (class_1792)class_2378.field_11142.method_10223(id2 = new class_2960(in))) == class_1802.field_8162) {
                    throw new CDSyntaxError("Failed to get item for input: " + in);
                }
                stack = new class_1799((class_1935)item);
            }
            return new StackIngredient(Collections.singletonList(stack), amount, tag, requireEmpty);
        }
        throw new CDSyntaxError("Illegal object passed to TechReborn ingredient parser of type " + input.getClass().getName());
    }

    public static FluidInstance parseFluid(String fluid) {
        int amount = 1000;
        int amtIndex = fluid.indexOf(64);
        if (amtIndex != -1) {
            String amtStr = fluid.substring(amtIndex + 1);
            fluid = fluid.substring(0, amtIndex);
            amount = Integer.parseInt(amtStr);
        }
        class_2960 id = new class_2960(fluid);
        return new FluidInstance((class_3611)class_2378.field_11154.method_10223(id), FluidValue.fromRaw((int)amount));
    }
}

