/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.compat.rei.ReiPlugin;

public class MachineRecipeDisplay<R extends RebornRecipe>
implements RecipeDisplay {
    private final R recipe;
    private final List<List<EntryStack>> inputs;
    private final List<EntryStack> outputs;
    private int energy = 0;
    private int heat = 0;
    private int time = 0;
    private FluidInstance fluidInstance = null;

    public MachineRecipeDisplay(R recipe) {
        this.recipe = recipe;
        this.inputs = CollectionUtils.map((List)recipe.getRebornIngredients(), ing -> EntryStack.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.outputs = EntryStack.ofItemStacks((Collection)recipe.getOutputs());
        this.time = recipe.getTime();
        this.energy = recipe.getPower();
        if (recipe instanceof BlastFurnaceRecipe) {
            this.heat = ((BlastFurnaceRecipe)((Object)recipe)).getHeat();
        }
        if (recipe instanceof RebornFluidRecipe) {
            this.fluidInstance = ((RebornFluidRecipe)recipe).getFluidInstance();
            this.inputs.add(Collections.singletonList(EntryStack.create((class_3611)this.fluidInstance.getFluid(), (int)this.fluidInstance.getAmount().getRawValue())));
        }
        for (List<EntryStack> entries : this.inputs) {
            for (EntryStack stack : entries) {
                ReiPlugin.applyCellEntry(stack);
            }
        }
        for (EntryStack stack : this.outputs) {
            ReiPlugin.applyCellEntry(stack);
        }
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getTime() {
        return this.time;
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(this.recipe).map(RebornRecipe::method_8114);
    }

    public List<List<EntryStack>> getInputEntries() {
        return this.inputs;
    }

    public List<List<EntryStack>> getRequiredEntries() {
        return this.inputs;
    }

    public List<EntryStack> getOutputEntries() {
        return this.outputs;
    }

    public class_2960 getRecipeCategory() {
        return this.recipe.getRebornRecipeType().getName();
    }
}

