/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.client.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import reborncore.api.IListInfoProvider;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHolder;
import team.reborn.energy.EnergySide;
import techreborn.TechReborn;
import techreborn.init.TRContent;
import techreborn.items.UpgradeItem;
import techreborn.utils.ToolTipAssistUtils;
import techreborn.utils.WIP;

public class StackToolTipHandler
implements ItemTooltipCallback {
    private static final ArrayList<class_2248> wipBlocks = new ArrayList();
    public static final Map<class_1792, Boolean> ITEM_ID = Maps.newHashMap();

    public static void setup() {
        ItemTooltipCallback.EVENT.register((Object)new StackToolTipHandler());
    }

    public void getTooltip(class_1799 stack, class_1836 tooltipContext, List<class_2561> components) {
        class_1792 item = stack.method_7909();
        if (!ITEM_ID.computeIfAbsent(item, this::isTRItem).booleanValue()) {
            return;
        }
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (wipBlocks.contains(block) || block instanceof WIP) {
            components.add((class_2561)new class_2588("techreborn.tooltip.wip").method_27692(class_124.field_1061));
        }
        if (block instanceof BaseBlockEntityProvider) {
            ToolTipAssistUtils.addInfo(item.method_7876(), components);
        }
        if (item instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            ToolTipAssistUtils.addInfo(item.method_7876(), components, false);
            components.addAll(ToolTipAssistUtils.getUpgradeStats(TRContent.Upgrades.valueOf(upgrade.name.toUpperCase()), stack.method_7947(), class_437.method_25442()));
        }
        if (item instanceof IListInfoProvider) {
            ((IListInfoProvider)item).addInfo(components, false, false);
        } else if (stack.method_7909() instanceof EnergyHolder) {
            class_2585 line1 = new class_2585(PowerSystem.getLocaliszedPowerFormattedNoSuffix((double)Energy.of((Object)stack).getEnergy()));
            line1.method_27693("/");
            line1.method_27693(PowerSystem.getLocaliszedPowerFormattedNoSuffix((double)Energy.of((Object)stack).getMaxStored()));
            line1.method_27693(" ");
            line1.method_27693(PowerSystem.getDisplayPower().abbreviation);
            line1.method_27692(class_124.field_1065);
            components.add(1, (class_2561)line1);
            if (class_437.method_25442()) {
                int percentage = this.percentage(Energy.of((Object)stack).getMaxStored(), Energy.of((Object)stack).getEnergy());
                class_124 color = StringUtils.getPercentageColour((int)percentage);
                components.add(2, (class_2561)new class_2585(color + "" + percentage + "%" + class_124.field_1080 + " Charged"));
                components.add(3, (class_2561)new class_2585(class_124.field_1080 + "I/O Rate: " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted((double)((EnergyHolder)item).getMaxInput(EnergySide.UNKNOWN))));
            }
        } else {
            try {
                if (block instanceof class_2343 && class_2378.field_11146.method_10221((Object)block).method_12836().contains("techreborn")) {
                    class_2586 blockEntity = ((class_2343)block).method_10123((class_1922)class_310.method_1551().field_1687);
                    boolean hasData = false;
                    if (stack.method_7985() && stack.method_7969().method_10545("blockEntity_data")) {
                        class_2487 blockEntityData = stack.method_7969().method_10562("blockEntity_data");
                        blockEntity.method_11014(blockEntity.method_11010(), blockEntityData);
                        hasData = true;
                        components.add((class_2561)new class_2585("Block data contained").method_27692(class_124.field_1077));
                    }
                    if (blockEntity instanceof IListInfoProvider) {
                        ((IListInfoProvider)blockEntity).addInfo(components, false, hasData);
                    }
                }
            }
            catch (NullPointerException e) {
                TechReborn.LOGGER.debug("Failed to load info for " + stack.method_7964());
            }
        }
    }

    private boolean isTRItem(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item).method_12836().equals("techreborn");
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public int percentage(double MaxValue, double CurrentValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }
}

