/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2997;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3284;
import net.minecraft.class_3297;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import reborncore.common.world.CustomOreFeature;
import reborncore.common.world.CustomOreFeatureConfig;
import techreborn.blocks.misc.BlockRubberLog;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;
import techreborn.world.RubberTreeDecorator;
import techreborn.world.RubberTreeFeature;

public class WorldGenerator {
    public static class_3031<class_4643> RUBBER_TREE_FEATURE;
    public static RubberTreeDecorator RUBBER_TREE_DECORATOR;
    public static class_4643 RUBBER_TREE_CONFIG;
    private static final List<class_1959> checkedBiomes;

    public static void initBiomeFeatures() {
        WorldGenerator.setupTrees();
        for (class_1959 biome2 : class_2378.field_11153) {
            WorldGenerator.addToBiome(biome2);
        }
        RegistryEntryAddedCallback.event((class_2378)class_2378.field_11153).register((i, identifier, biome) -> WorldGenerator.addToBiome(biome));
    }

    private static void setupTrees() {
        RUBBER_TREE_FEATURE = (class_3031)class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("techreborn:rubber_tree"), (Object)((Object)new RubberTreeFeature((Codec<class_4643>)class_4643.field_24921)));
        RUBBER_TREE_DECORATOR = (RubberTreeDecorator)((Object)class_2378.method_10230((class_2378)class_2378.field_11148, (class_2960)new class_2960("techreborn:rubber_tree"), (Object)((Object)new RubberTreeDecorator((Codec<class_3297>)class_3297.field_24980))));
        class_4657 logProvider = new class_4657();
        logProvider.method_23458(TRContent.RUBBER_LOG.method_9564(), 10);
        Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179()).map(direction -> (class_2680)((class_2680)TRContent.RUBBER_LOG.method_9564().method_11657((class_2769)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BlockRubberLog.SAP_SIDE, (Comparable)direction)).forEach(state -> logProvider.method_23458(state, 1));
        RUBBER_TREE_CONFIG = new class_4643.class_4644((class_4651)logProvider, (class_4651)new class_4656(TRContent.RUBBER_LEAVES.method_9564()), (class_4647)new RubberTreeFeature.FoliagePlacer(2, 0, 0, 0, 3), (class_5141)new class_5140(TechRebornConfig.rubberTreeBaseHeight, 3, 0), (class_5201)new class_5204(1, 0, 1)).method_23445();
    }

    private static void addToBiome(class_1959 biome) {
        if (checkedBiomes.contains(biome)) {
            return;
        }
        checkedBiomes.add(biome);
        if (biome.method_8688() == class_1959.class_1961.field_9366) {
            if (TechRebornConfig.enableCinnabarOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13727, TRContent.Ores.CINNABAR);
            }
            if (TechRebornConfig.enablePyriteOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13727, TRContent.Ores.PYRITE);
            }
            if (TechRebornConfig.enableSphaleriteOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13727, TRContent.Ores.SPHALERITE);
            }
        } else if (biome.method_8688() == class_1959.class_1961.field_9360) {
            if (TechRebornConfig.enablePeridotOre) {
                WorldGenerator.addEndOre(biome, TRContent.Ores.PERIDOT);
            }
            if (TechRebornConfig.enableSheldoniteOre) {
                WorldGenerator.addEndOre(biome, TRContent.Ores.SHELDONITE);
            }
            if (TechRebornConfig.enableSodaliteOre) {
                WorldGenerator.addEndOre(biome, TRContent.Ores.SODALITE);
            }
            if (TechRebornConfig.enableTungstenOre) {
                WorldGenerator.addEndOre(biome, TRContent.Ores.TUNGSTEN);
            }
        } else {
            if (TechRebornConfig.enableBauxiteOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.BAUXITE);
            }
            if (TechRebornConfig.enableCopperOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.COPPER);
            }
            if (TechRebornConfig.enableGalenaOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.GALENA);
            }
            if (TechRebornConfig.enableIridiumOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.IRIDIUM);
            }
            if (TechRebornConfig.enableLeadOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.LEAD);
            }
            if (TechRebornConfig.enableRubyOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.RUBY);
            }
            if (TechRebornConfig.enableSapphireOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.SAPPHIRE);
            }
            if (TechRebornConfig.enableSilverOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.SILVER);
            }
            if (TechRebornConfig.enableTinOre) {
                WorldGenerator.addOre(biome, class_3124.class_3125.field_13730, TRContent.Ores.TIN);
            }
            if (biome.method_8688() == class_1959.class_1961.field_9370 || biome.method_8688() == class_1959.class_1961.field_9361 || biome.method_8688() == class_1959.class_1961.field_9364) {
                biome.method_8719(class_2893.class_2895.field_13178, RUBBER_TREE_FEATURE.method_23397((class_3037)RUBBER_TREE_CONFIG).method_23388(RUBBER_TREE_DECORATOR.method_23475((class_2998)new class_3297(biome.method_8688() == class_1959.class_1961.field_9364 ? TechRebornConfig.rubberTreeChance / 3 : TechRebornConfig.rubberTreeChance))));
            }
        }
    }

    private static void addOre(class_1959 biome, class_3124.class_3125 canReplaceIn, TRContent.Ores ore) {
        biome.method_8719(class_2893.class_2895.field_13176, class_3031.field_13517.method_23397((class_3037)new class_3124(canReplaceIn, ore.block.method_9564(), ore.veinSize)).method_23388(class_3284.field_14241.method_23475((class_2998)new class_2997(ore.veinsPerChunk, ore.minY, ore.minY, ore.maxY))));
    }

    private static void addEndOre(class_1959 biome, TRContent.Ores ore) {
        biome.method_8719(class_2893.class_2895.field_13176, CustomOreFeature.CUSTOM_ORE_FEATURE.method_23397((class_3037)new CustomOreFeatureConfig(blockState -> blockState.method_26204() == class_2246.field_10471, ore.block.method_9564(), ore.veinSize)).method_23388(class_3284.field_14241.method_23475((class_2998)new class_2997(ore.veinsPerChunk, ore.minY, ore.minY, ore.maxY))));
    }

    static {
        checkedBiomes = new ArrayList<class_1959>();
    }
}

