/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone;

import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.capabilities.CapabilityPlayerPosAndDim;
import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzBlockMechanicsConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzDungeonsConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.dimension.BzDimension;
import com.telepathicgrunt.the_bumblezone.effects.BzEffects;
import com.telepathicgrunt.the_bumblezone.entities.BzEntities;
import com.telepathicgrunt.the_bumblezone.features.BzConfiguredFeatures;
import com.telepathicgrunt.the_bumblezone.features.BzFeatures;
import com.telepathicgrunt.the_bumblezone.features.decorators.BzPlacements;
import com.telepathicgrunt.the_bumblezone.items.BzItems;
import com.telepathicgrunt.the_bumblezone.items.DispenserItemSetup;
import com.telepathicgrunt.the_bumblezone.modCompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.surfacebuilders.BzSurfaceBuilders;
import com.telepathicgrunt.the_bumblezone.utils.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_bumblezone")
public class Bumblezone {
    public static final String MODID = "the_bumblezone";
    public static final ResourceLocation MOD_DIMENSION_ID = new ResourceLocation("the_bumblezone", "the_bumblezone");
    public static final List<ResourceLocation> BIOME_ID_LIST = Arrays.asList(new ResourceLocation("the_bumblezone", "hive_pillar"), new ResourceLocation("the_bumblezone", "hive_wall"), new ResourceLocation("the_bumblezone", "sugar_water_floor"));
    public static final Logger LOGGER = LogManager.getLogger((String)"the_bumblezone");
    public static BzBeeAggressionConfigs.BzBeeAggressionConfigValues BzBeeAggressionConfig = null;
    public static BzBlockMechanicsConfigs.BzBlockMechanicsConfigValues BzBlockMechanicsConfig = null;
    public static BzDimensionConfigs.BzDimensionConfigValues BzDimensionConfig = null;
    public static BzDungeonsConfigs.BzDungeonsConfigValues BzDungeonsConfig = null;
    public static BzModCompatibilityConfigs.BzModCompatibilityConfigValues BzModCompatibilityConfig = null;

    public Bumblezone() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BumblezoneClient.subscribeClientEvents(modEventBus, forgeBus));
        BzModCompatibilityConfig = ConfigHelper.register(ModConfig.Type.SERVER, BzModCompatibilityConfigs.BzModCompatibilityConfigValues::new, "the_bumblezone-mod_compatibility.toml");
        BzBlockMechanicsConfig = ConfigHelper.register(ModConfig.Type.SERVER, BzBlockMechanicsConfigs.BzBlockMechanicsConfigValues::new, "the_bumblezone-block_mechanics.toml");
        BzBeeAggressionConfig = ConfigHelper.register(ModConfig.Type.SERVER, BzBeeAggressionConfigs.BzBeeAggressionConfigValues::new, "the_bumblezone-bee_aggression.toml");
        BzDimensionConfig = ConfigHelper.register(ModConfig.Type.SERVER, BzDimensionConfigs.BzDimensionConfigValues::new, "the_bumblezone-dimension.toml");
        BzDungeonsConfig = ConfigHelper.register(ModConfig.Type.SERVER, BzDungeonsConfigs.BzDungeonsConfigValues::new, "the_bumblezone-dungeons.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityPlayerPosAndDim.register();
        BzDimension.setupDimension();
        DispenserItemSetup.setupDispenserBehaviors();
        DeferredWorkQueue.runLater(Bumblezone::lateSetup);
    }

    private static void lateSetup() {
        ModChecker.setupModCompat();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            BzBlocks.registerBlocks();
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            BzItems.registerItems();
        }

        @SubscribeEvent
        public static void registerEntity(RegistryEvent.Register<EntityType<?>> event) {
            BzEntities.registerEntities();
        }

        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            BzFeatures.registerFeatures();
            BzConfiguredFeatures.registerConfiguredFeatures();
        }

        @SubscribeEvent
        public static void onRegisterEffects(RegistryEvent.Register<Effect> event) {
            BzEffects.registerEffects();
        }

        @SubscribeEvent
        public static void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
            BzPlacements.registerPlacements();
        }

        @SubscribeEvent
        public static void onRegisterSurfacebuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            BzSurfaceBuilders.registerSurfaceBuilders();
        }

        @SubscribeEvent
        public static void onRegisterSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            BzItems.registerCustomRecipes(event);
        }
    }
}

