/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.Maps;
import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.items.BzItems;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HoneyCrystal
extends Block {
    private static final ResourceLocation EMPTY_FLUID_RL = new ResourceLocation("minecraft:empty");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    protected static final VoxelShape DOWN_AABB = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    public static final Map<Direction, VoxelShape> FACING_TO_SHAPE_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH_AABB);
        map.put(Direction.EAST, EAST_AABB);
        map.put(Direction.SOUTH, SOUTH_AABB);
        map.put(Direction.WEST, WEST_AABB);
        map.put(Direction.UP, UP_AABB);
        map.put(Direction.DOWN, DOWN_AABB);
    });
    private Item item;

    public HoneyCrystal() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151676_q).func_235838_a_(blockstate -> 1).func_200948_a(0.3f, 0.3f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? BzBlocks.SUGAR_WATER_FLUID.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState blockstate, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return FACING_TO_SHAPE_MAP.get(blockstate.func_177229_b((Property)FACING));
    }

    public boolean func_196260_a(BlockState blockstate, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)blockstate.func_177229_b((Property)FACING);
        BlockState attachedBlockstate = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        return attachedBlockstate.func_224755_d((IBlockReader)world, pos.func_177972_a(direction.func_176734_d()), direction);
    }

    public BlockState func_196271_a(BlockState blockstate, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == blockstate.func_177229_b((Property)FACING) && !blockstate.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)blockstate.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)BzBlocks.SUGAR_WATER_FLUID, BzBlocks.SUGAR_WATER_FLUID.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockstate, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState attachedBlockstate;
        if (!context.func_196012_c() && (attachedBlockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()))).func_177230_c() == this && attachedBlockstate.func_177229_b((Property)FACING) == context.func_196000_l()) {
            return null;
        }
        BlockState blockstate = this.func_176223_P();
        World worldReader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            if (!(blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_196955_c((IWorldReader)worldReader, blockpos)) continue;
            return (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a)));
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState blockstate, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand, BlockRayTraceResult raytraceResult) {
        if (blockstate.func_177230_c() != this) {
            return super.func_225533_a_(blockstate, world, position, playerEntity, playerHand, raytraceResult);
        }
        ItemStack itemstack = playerEntity.func_184586_b(playerHand);
        if (itemstack.func_77973_b() instanceof BucketItem) {
            if (((BucketItem)itemstack.func_77973_b()).getFluid().func_207185_a((ITag)FluidTags.field_206959_a) && !((Boolean)blockstate.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_175656_a(position, (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                world.func_205219_F_().func_205360_a(position, (Object)BzBlocks.SUGAR_WATER_FLUID, BzBlocks.SUGAR_WATER_FLUID.func_205569_a((IWorldReader)world));
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_204326_e, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!playerEntity.func_184812_l_()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                return ActionResultType.SUCCESS;
            }
            if (((BucketItem)itemstack.func_77973_b()).getFluid().getRegistryName().equals((Object)EMPTY_FLUID_RL) && ((Boolean)blockstate.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_175656_a(position, (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_204326_e, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!playerEntity.func_184812_l_()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BUCKET));
                }
                return ActionResultType.SUCCESS;
            }
        } else if (itemstack.func_77973_b() == Items.field_151069_bo) {
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE));
            } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE))) {
                playerEntity.func_71019_a(new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE), false);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)BzItems.HONEY_CRYSTAL));
    }

    public Item func_199767_j() {
        if (this.item == null) {
            this.item = BzItems.HONEY_CRYSTAL_SHARDS;
        }
        return this.item;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }
}

