/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.blocks.StickyHoneyResidue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StickyHoneyRedstone
extends StickyHoneyResidue {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final AxisAlignedBB DOWN_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final AxisAlignedBB UP_REAL_AABB = new AxisAlignedBB(0.0, 0.8, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.2);
    protected static final AxisAlignedBB EAST_REAL_AABB = new AxisAlignedBB(0.8, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.2, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_REAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.2, 1.0, 1.0, 1.0);
    public static final Map<Direction, AxisAlignedBB> FACING_TO_AABB_MAP;

    public StickyHoneyRedstone() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176277_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176273_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176278_M, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176279_N, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176280_O, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[0]).func_206894_a(new Property[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O, DOWN, POWERED});
    }

    @Override
    @Deprecated
    public void func_196262_a(BlockState blockstate, World world, BlockPos pos, Entity entity) {
        this.updateState(world, pos, blockstate, 0);
        super.func_196262_a(blockstate, world, pos, entity);
    }

    protected int getTickRate() {
        return 20;
    }

    public void func_225534_a_(BlockState blockstate, ServerWorld world, BlockPos pos, Random rand) {
        this.updateState((World)world, pos, blockstate, (Boolean)blockstate.func_177229_b((Property)POWERED) != false ? 1 : 0);
    }

    protected void neighborChangeds(BlockState blockstate, World world, BlockPos pos) {
        if (blockstate.func_177230_c() != BzBlocks.STICKY_HONEY_REDSTONE) {
            return;
        }
        if (((Boolean)blockstate.func_177229_b((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(Direction.DOWN))).booleanValue()) {
            world.func_230547_a_(pos, (Block)this);
        }
        for (Direction direction : Direction.values()) {
            BooleanProperty booleanproperty = StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(direction);
            if (!((Boolean)blockstate.func_177229_b((Property)booleanproperty)).booleanValue()) continue;
            world.func_195593_d(pos.func_177972_a(direction), (Block)this);
        }
    }

    protected void updateState(World world, BlockPos pos, BlockState oldBlockstate, int oldRedstoneStrength) {
        boolean flag1;
        int newPower = this.computeRedstoneStrength(oldBlockstate, world, pos);
        boolean bl = flag1 = newPower > 0;
        if (oldRedstoneStrength != newPower) {
            BlockState newBlockstate = this.setRedstoneStrength(oldBlockstate, newPower);
            world.func_180501_a(pos, newBlockstate, 2);
            this.neighborChangeds(oldBlockstate, world, pos);
            world.func_217393_a(pos, oldBlockstate, newBlockstate);
        }
        if (flag1) {
            world.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, this.getTickRate());
        }
    }

    public void func_196243_a(BlockState blockstate, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && blockstate.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)blockstate.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateTarget(world, pos, blockstate);
            }
            super.func_196243_a(blockstate, world, pos, newState, false);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean moved) {
        this.updateTarget(world, pos, state);
    }

    protected void updateTarget(World world, BlockPos pos, BlockState blockstate) {
        for (Direction direction : Direction.values()) {
            if (!((Boolean)blockstate.func_177229_b((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            BlockPos blockPos = pos.func_177972_a(direction);
            world.func_190524_a(blockPos, (Block)this, pos);
            world.func_175695_a(blockPos, (Block)this, direction);
        }
    }

    public void onPlaced(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (this.computeRedstoneStrength(state, world, pos) > 0) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockstate, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockstate.func_177229_b((Property)POWERED)).booleanValue() && ((Boolean)blockstate.func_177229_b((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(Direction.DOWN))).booleanValue()) {
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                if (horizontal != side) continue;
                return 1;
            }
        }
        return (Boolean)blockstate.func_177229_b((Property)POWERED) != false && (Boolean)blockstate.func_177229_b((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(side.func_176734_d())) != false ? 1 : 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        boolean canConnect = false;
        if (((Boolean)state.func_177229_b((Property)StickyHoneyResidue.FACING_TO_PROPERTY_MAP.get(Direction.DOWN))).booleanValue()) {
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                if (horizontal != side) continue;
                canConnect = true;
                break;
            }
        }
        return canConnect;
    }

    public int func_176211_b(BlockState blockstate, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockstate, blockAccess, pos, side);
    }

    protected BlockState setRedstoneStrength(BlockState blockstate, int strength) {
        return (BlockState)blockstate.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(BlockState blockstate, World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = this.func_220053_a(blockstate, (IBlockReader)world, pos, null).func_197752_a().func_186670_a(pos);
        List list = world.func_225317_b(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            return 1;
        }
        return 0;
    }

    static {
        HashMap<Direction, AxisAlignedBB> map = new HashMap<Direction, AxisAlignedBB>();
        map.put(Direction.DOWN, DOWN_REAL_AABB);
        map.put(Direction.UP, UP_REAL_AABB);
        map.put(Direction.EAST, EAST_REAL_AABB);
        map.put(Direction.WEST, WEST_REAL_AABB);
        map.put(Direction.NORTH, NORTH_REAL_AABB);
        map.put(Direction.SOUTH, SOUTH_REAL_AABB);
        FACING_TO_AABB_MAP = map;
    }
}

