/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.client.rendering.FluidRender;
import com.telepathicgrunt.the_bumblezone.client.rendering.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.dimension.BzSkyProperty;
import com.telepathicgrunt.the_bumblezone.entities.BzEntities;
import com.telepathicgrunt.the_bumblezone.items.BzItems;
import com.telepathicgrunt.the_bumblezone.mixin.SkyPropertiesAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class BumblezoneClient {
    public static final ResourceLocation FLUID_STILL = new ResourceLocation("the_bumblezone:block/sugar_water_still");
    public static final ResourceLocation FLUID_FLOWING = new ResourceLocation("the_bumblezone:block/sugar_water_flow");

    public static void subscribeClientEvents(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(BumblezoneClient::onClientSetup);
        modBus.addListener(BumblezoneClient::registerItemColors);
        forgeBus.addListener(FluidRender::sugarWaterOverlay);
    }

    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, tintIndex) -> ((SpawnEggItem)BzItems.HONEY_SLIME_SPAWN_EGG).func_195983_a(tintIndex), new IItemProvider[]{BzItems.HONEY_SLIME_SPAWN_EGG});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(BzEntities.HONEY_SLIME, HoneySlimeRendering::new);
        SkyPropertiesAccessor.getBY_ResourceLocation().put((Object)new ResourceLocation("the_bumblezone", "sky_property"), (Object)new BzSkyProperty());
        FluidRender.setupFluidRendering((Fluid)BzBlocks.SUGAR_WATER_FLUID, (Fluid)BzBlocks.SUGAR_WATER_FLUID_FLOWING, FLUID_STILL, FLUID_FLOWING);
        DeferredWorkQueue.runLater(() -> {
            RenderTypeLookup.setRenderLayer((Block)BzBlocks.STICKY_HONEY_REDSTONE, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)BzBlocks.STICKY_HONEY_RESIDUE, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)BzBlocks.HONEY_CRYSTAL, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)BzBlocks.SUGAR_WATER_BLOCK, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)BzBlocks.SUGAR_WATER_FLUID, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)BzBlocks.SUGAR_WATER_FLUID_FLOWING, (RenderType)RenderType.func_228645_f_());
        });
    }
}

