/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.dimension;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.IPlayerPosAndDim;
import com.telepathicgrunt.the_bumblezone.capabilities.PlayerPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.dimension.BzDimension;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import org.apache.logging.log4j.Level;

public class BzPlayerPlacement {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;

    public static void enteringBumblezone(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)entity;
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            cap.setNonBZDim(playerEntity.func_130014_f_().func_234923_W_().func_240901_a_());
            cap.setNonBZYaw(playerEntity.field_70177_z);
            cap.setNonBZPitch(playerEntity.field_70125_A);
            cap.setNonBZPos(playerEntity.func_213303_ch());
            MinecraftServer minecraftServer = playerEntity.func_184102_h();
            ServerWorld bumblezoneWorld = minecraftServer.func_71218_a(BzDimension.BZ_WORLD_KEY);
            if (bumblezoneWorld == null) {
                Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                StringTextComponent message = new StringTextComponent("Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: \u00c2\u00a76https://bugs.mojang.com/browse/MC-195468\u00c2\u00a7f. A restart will fix this.");
                playerEntity.func_146105_b((ITextComponent)message, true);
                return;
            }
            Vector3d destinationPosition = BzPlayerPlacement.teleportByPearl((PlayerEntity)playerEntity, playerEntity.func_71121_q(), bumblezoneWorld);
            playerEntity.func_200619_a(bumblezoneWorld, destinationPosition.field_72450_a, destinationPosition.field_72448_b, destinationPosition.field_72449_c, playerEntity.field_70177_z, playerEntity.field_70125_A);
        }
    }

    public static void exitingBumblezone(Entity entity, ServerWorld destination) {
        boolean upwardChecking;
        boolean bl = upwardChecking = entity.func_226278_cu_() > 0.0;
        if (entity instanceof ServerPlayerEntity) {
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)entity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            cap.setNonBZPos(entity.func_213303_ch());
            Vector3d destinationPosition = BzPlayerPlacement.teleportByOutOfBounds((PlayerEntity)entity, destination, upwardChecking);
            ((ServerPlayerEntity)entity).func_200619_a(destination, destinationPosition.field_72450_a, destinationPosition.field_72448_b, destinationPosition.field_72449_c, cap.getNonBZYaw(), cap.getNonBZPitch());
        }
    }

    private static Vector3d teleportByOutOfBounds(PlayerEntity playerEntity, ServerWorld destination, boolean checkingUpward) {
        BlockPos blockpos;
        double coordinateScale = destination.func_230315_m_().func_242724_f();
        BlockPos validBlockPos = null;
        PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
        if (Bumblezone.BzDimensionConfig.teleportationMode.get() != 2 || cap.getNonBZPos() == null) {
            blockpos = new BlockPos(Doubles.constrainToRange((double)(playerEntity.func_213303_ch().func_82615_a() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), playerEntity.func_213303_ch().func_82617_b(), Doubles.constrainToRange((double)(playerEntity.func_213303_ch().func_82616_c() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = BzPlayerPlacement.validPlayerSpawnLocationByBeehive((World)destination, blockpos, 48, checkingUpward);
        } else {
            blockpos = new BlockPos(playerEntity.func_213303_ch());
        }
        if ((Bumblezone.BzDimensionConfig.teleportationMode.get() == 2 || Bumblezone.BzDimensionConfig.teleportationMode.get() == 3 && validBlockPos == null) && destination.func_180495_p((validBlockPos = cap.getNonBZPos() == null ? blockpos : new BlockPos(cap.getNonBZPos())).func_177984_a()).func_200132_m()) {
            destination.func_180501_a(validBlockPos, Blocks.field_150350_a.func_176223_P(), 3);
            destination.func_180501_a(validBlockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new Vector3d((double)validBlockPos.func_177958_n() + 0.5, (double)(validBlockPos.func_177956_o() + 1), (double)validBlockPos.func_177952_p() + 0.5);
    }

    private static Vector3d teleportByPearl(PlayerEntity playerEntity, ServerWorld originalWorld, ServerWorld bumblezoneWorld) {
        int heightCheck;
        double coordinateScale = originalWorld.func_230315_m_().func_242724_f();
        BlockPos blockpos = new BlockPos(playerEntity.func_213303_ch().func_82615_a() * coordinateScale, playerEntity.func_213303_ch().func_82617_b(), playerEntity.func_213303_ch().func_82616_c() * coordinateScale);
        Object validBlockPos = BzPlayerPlacement.validPlayerSpawnLocation((World)bumblezoneWorld, blockpos, 10);
        if (validBlockPos == null) {
            validBlockPos = new BlockPos(blockpos.func_177958_n(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((IWorld)bumblezoneWorld, blockpos.func_177956_o(), 0, blockpos) + 1, blockpos.func_177952_p());
            if (validBlockPos.func_177956_o() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.func_180495_p(validBlockPos).func_185904_a() == Material.field_151586_h && bumblezoneWorld.func_180495_p(validBlockPos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
                BlockPos.Mutable mutable = new BlockPos.Mutable(validBlockPos.func_177958_n(), validBlockPos.func_177956_o(), validBlockPos.func_177952_p());
                while (mutable.func_177956_o() < 255 && !bumblezoneWorld.func_175623_d((BlockPos)mutable) || bumblezoneWorld.func_180495_p((BlockPos)mutable).func_185904_a() == Material.field_151586_h) {
                    mutable.func_189536_c(Direction.UP);
                }
                validBlockPos = bumblezoneWorld.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a ? null : mutable;
            } else if (!bumblezoneWorld.func_175623_d(validBlockPos) && bumblezoneWorld.func_180495_p(validBlockPos).func_185904_a() != Material.field_151586_h && bumblezoneWorld.func_180495_p(validBlockPos.func_177984_a()).func_185904_a() != Material.field_151579_a) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177977_b(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177984_a().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177978_c(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177976_e(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177974_f(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177968_d(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177978_c().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177976_e().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177974_f().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177968_d().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                validBlockPos = blockpos;
            }
        }
        if (playerEntity.func_70608_bn()) {
            playerEntity.func_213366_dy();
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.func_177956_o() && bumblezoneWorld.func_180495_p(validBlockPos.func_177979_c(heightCheck)).func_196958_f(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.func_177956_o()) {
            bumblezoneWorld.func_175656_a(validBlockPos.func_177956_o() == 0 ? validBlockPos : validBlockPos.func_177977_b(), Blocks.field_226908_md_.func_176223_P());
        }
        return new Vector3d((double)validBlockPos.func_177958_n() + 0.5, (double)validBlockPos.func_177956_o(), (double)validBlockPos.func_177952_p() + 0.5);
    }

    private static BlockPos validPlayerSpawnLocationByBeehive(World world, BlockPos position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        int halfRange = maximumRange / 2;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (int x = -halfRange; x < halfRange; ++x) {
            for (int z = -halfRange; z < halfRange; ++z) {
                mutableBlockPos.func_181079_c(position.func_177958_n() + x, 0, position.func_177952_p() + z);
                if (!world.func_217354_b(mutableBlockPos.func_177958_n() >> 4, mutableBlockPos.func_177952_p() >> 4)) {
                    world.func_217349_x((BlockPos)mutableBlockPos);
                }
                maxHeight = Math.max(maxHeight, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, mutableBlockPos.func_177958_n(), mutableBlockPos.func_177952_p()));
            }
        }
        maxHeight = Math.min(maxHeight, world.func_217301_I() - 1);
        mutableBlockPos.func_181079_c(position.func_177958_n(), checkingUpward ? 0 : maxHeight, position.func_177952_p());
        while (mutableBlockPos.func_177956_o() >= 0 && mutableBlockPos.func_177956_o() <= maxHeight) {
            if (!Bumblezone.BzDimensionConfig.seaLevelOrHigherExitTeleporting.get().booleanValue() || mutableBlockPos.func_177956_o() > world.func_181545_F()) {
                for (int range = 0; range < maximumRange; ++range) {
                    int radius = range * range;
                    int nextRadius = (range + 1) * (range + 1);
                    for (int x = 0; x <= range * 2; ++x) {
                        int x2 = x > range ? -(x - range) : x;
                        for (int z = 0; z <= range * 2; ++z) {
                            BlockPos validSpot;
                            int z2;
                            int n = z2 = z > range ? -(z - range) : x;
                            if (x2 * x2 + z2 * z2 < radius || x2 * x2 + z2 * z2 >= nextRadius) continue;
                            mutableBlockPos.func_181079_c(position.func_177958_n() + x2, mutableBlockPos.func_177956_o(), position.func_177952_p() + z2);
                            if (world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() != Blocks.field_226905_ma_ || (validSpot = BzPlayerPlacement.validPlayerSpawnLocation(world, (BlockPos)mutableBlockPos, 4)) == null) continue;
                            return validSpot;
                        }
                    }
                }
            }
            if (checkingUpward) {
                mutableBlockPos.func_189536_c(Direction.UP);
                continue;
            }
            mutableBlockPos.func_189536_c(Direction.DOWN);
        }
        if (Bumblezone.BzDimensionConfig.teleportationMode.get() == 3) {
            return null;
        }
        if (maxHeight + 1 < world.func_217301_I()) {
            ++maxHeight;
        }
        mutableBlockPos.func_181079_c(position.func_177958_n(), BzPlacingUtils.topOfSurfaceBelowHeight((IWorld)world, maxHeight, 0, position), position.func_177952_p());
        if (mutableBlockPos.func_177956_o() <= 0) {
            mutableBlockPos.func_181079_c(position.func_177958_n(), world.func_217301_I() / 2, position.func_177952_p());
        }
        BzPlayerPlacement.createSpaceForPlayer(world, mutableBlockPos);
        return mutableBlockPos;
    }

    private static void createSpaceForPlayer(World world, BlockPos.Mutable mutableBlockPos) {
        if (Bumblezone.BzDimensionConfig.generateBeenest.get().booleanValue()) {
            world.func_175656_a((BlockPos)mutableBlockPos, Blocks.field_226905_ma_.func_176223_P());
        } else if (world.func_180495_p((BlockPos)mutableBlockPos).func_185904_a() == Material.field_151579_a || !world.func_180495_p((BlockPos)mutableBlockPos).func_204520_s().func_206888_e() && !world.func_180495_p((BlockPos)mutableBlockPos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            world.func_175656_a((BlockPos)mutableBlockPos, Blocks.field_226908_md_.func_176223_P());
        }
        world.func_175656_a(mutableBlockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
    }

    private static BlockPos validPlayerSpawnLocation(World world, BlockPos position, int maximumRange) {
        BlockPos.Mutable currentPos = new BlockPos.Mutable(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int range = 0; range < maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        int distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.func_189533_g((Vector3i)position.func_177982_a(x2, y2, z2));
                        if (!world.func_180495_p(currentPos.func_177977_b()).func_200132_m() || world.func_180495_p((BlockPos)currentPos).func_185904_a() != Material.field_151579_a || world.func_180495_p(currentPos.func_177984_a()).func_185904_a() != Material.field_151579_a) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

