/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.effects.BzEffects;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BeeAggression {
    private static final Set<EntityType<?>> SET_OF_BEE_HATED_ENTITIES = new HashSet();

    public static void setupBeeHatingList(World world) {
        if (SET_OF_BEE_HATED_ENTITIES.size() != 0) {
            SET_OF_BEE_HATED_ENTITIES.clear();
        }
        for (EntityType entityType : Registry.field_212629_r) {
            Entity entity;
            if (entityType.func_220339_d() != EntityClassification.MONSTER && entityType.func_220339_d() != EntityClassification.CREATURE && entityType.func_220339_d() != EntityClassification.AMBIENT || !((entity = entityType.func_200721_a(world)) instanceof MobEntity)) continue;
            String mobName = Registry.field_212629_r.func_177774_c((Object)entityType).toString();
            MobEntity mobEntity = (MobEntity)entity;
            if ((mobEntity.func_70668_bt() != CreatureAttribute.field_223224_c_ || mobName.contains("bee")) && !(mobEntity instanceof PandaEntity) && !mobName.contains("bear") && !mobName.contains("wasp")) continue;
            SET_OF_BEE_HATED_ENTITIES.add(entityType);
        }
    }

    public static void honeyPickupAnger(PlayerEntity player, Item item) {
        if ((player.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !player.func_184812_l_() && !player.func_175149_v() && item == Items.field_226639_pY_ && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue()) {
            if (player.func_70644_a(BzEffects.PROTECTION_OF_THE_HIVE)) {
                player.func_195063_d(BzEffects.PROTECTION_OF_THE_HIVE);
            } else {
                player.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
            }
        }
    }

    public static void honeyDrinkAnger(ItemStack stack, World world, LivingEntity user) {
        if (user instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)user;
            if (!world.field_72995_K && (playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && stack.func_77973_b() == Items.field_226638_pX_) {
                if (playerEntity.func_70644_a(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    playerEntity.func_195063_d(BzEffects.PROTECTION_OF_THE_HIVE);
                } else {
                    playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            }
        }
    }

    public static void beeHitAndAngered(Entity entity, Entity attackerEntity) {
        if (!entity.field_70170_p.field_72995_K && (entity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && entity instanceof BeeEntity && attackerEntity != null) {
            if (attackerEntity instanceof PlayerEntity && !((PlayerEntity)attackerEntity).func_184812_l_() && !attackerEntity.func_175149_v()) {
                PlayerEntity player = (PlayerEntity)attackerEntity;
                if (player.func_70644_a(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    player.func_195063_d(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(player.field_70170_p, (LivingEntity)player);
                } else {
                    player.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            } else if (attackerEntity instanceof MobEntity) {
                MobEntity mob = (MobEntity)attackerEntity;
                if (mob.func_70644_a(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    mob.func_195063_d(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(mob.field_70170_p, (LivingEntity)mob);
                } else {
                    mob.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, true));
                }
            }
        }
    }

    public static void entityTypeBeeAnger(Entity entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((MobEntity)entity).func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            return SET_OF_BEE_HATED_ENTITIES.contains(entity.func_200600_R()) && !mobEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE);
        }
        return false;
    }

    public static void playerTick(PlayerEntity playerEntity) {
        if (!playerEntity.field_70170_p.field_72995_K && playerEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE) && !Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue() && !playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            playerEntity.func_195063_d(BzEffects.WRATH_OF_THE_HIVE);
            WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
        }
        boolean wrathEffect = playerEntity.func_70644_a(BzEffects.WRATH_OF_THE_HIVE);
        if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
            WrathOfTheHiveEffect.ACTIVE_WRATH = true;
        } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
            WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
            WrathOfTheHiveEffect.ACTIVE_WRATH = false;
        }
    }

    @Mod.EventBusSubscriber(modid="the_bumblezone")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void HoneyPickupEvent(PlayerEvent.ItemPickupEvent event) {
            BeeAggression.honeyPickupAnger(event.getPlayer(), event.getStack().func_77973_b());
        }
    }
}

