/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.IPlayerPosAndDim;
import com.telepathicgrunt.the_bumblezone.capabilities.PlayerPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.dimension.BzPlayerPlacement;
import com.telepathicgrunt.the_bumblezone.modCompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modCompat.ProductiveBeesRedirection;
import java.util.ArrayList;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlayerTeleportation {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;

    public static void playerTick(PlayerEntity playerEntity) {
        PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
        if (playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (playerEntity.func_226278_cu_() < -3.0) {
                playerEntity.func_226288_n_(playerEntity.func_226277_ct_(), -3.01, playerEntity.func_226281_cx_());
                playerEntity.func_70107_b(playerEntity.func_226277_ct_(), -3.01, playerEntity.func_226281_cx_());
                PlayerTeleportation.teleportOutOfBz(playerEntity);
            } else if (playerEntity.func_226278_cu_() > 255.0) {
                PlayerTeleportation.teleportOutOfBz(playerEntity);
            }
        } else if (cap.getTeleporting()) {
            BzPlayerPlacement.enteringBumblezone((Entity)playerEntity);
            cap.setTeleporting(false);
            PlayerTeleportation.reAddStatusEffect(playerEntity);
        }
    }

    private static void teleportOutOfBz(PlayerEntity playerEntity) {
        if (!playerEntity.func_130014_f_().field_72995_K) {
            PlayerTeleportation.checkAndCorrectStoredDimension(playerEntity);
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            RegistryKey world_key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)cap.getNonBZDim());
            BzPlayerPlacement.exitingBumblezone((Entity)playerEntity, playerEntity.func_130014_f_().func_73046_m().func_71218_a(world_key));
            PlayerTeleportation.reAddStatusEffect(playerEntity);
        }
    }

    private static void reAddStatusEffect(PlayerEntity playerEntity) {
        ArrayList effectInstanceList = new ArrayList(playerEntity.func_70651_bq());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            EffectInstance effectInstance = (EffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            playerEntity.func_195063_d(effectInstance.func_188419_a());
            playerEntity.func_195064_c(new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b(), effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e(), effectInstance.func_205348_f()));
        }
    }

    private static void checkAndCorrectStoredDimension(PlayerEntity playerEntity) {
        PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
        if (cap.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzDimensionConfig.forceExitToOverworld.get().booleanValue()) {
            cap.setNonBZDim(World.field_234918_g_.func_240901_a_());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean runEnderpearlImpact(RayTraceResult hitResult, EnderPearlEntity pearlEntity) {
        block10: {
            boolean validBelowBlock;
            boolean hitHive;
            ServerPlayerEntity playerEntity;
            block9: {
                block11: {
                    World world = pearlEntity.field_70170_p;
                    if (world.field_72995_K || !(pearlEntity.func_234616_v_() instanceof ServerPlayerEntity)) break block10;
                    playerEntity = (ServerPlayerEntity)pearlEntity.func_234616_v_();
                    Vector3d hitBlockPos = hitResult.func_216347_e();
                    BlockPos hivePos = new BlockPos(0, 0, 0);
                    hitHive = false;
                    for (double offset = -0.1; offset <= 0.1; offset += 0.2) {
                        BlockState block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(offset, 0.0, 0.0)));
                        if (PlayerTeleportation.isValidBeeHive(block)) {
                            hitHive = true;
                            hivePos = new BlockPos(hitBlockPos.func_72441_c(offset, 0.0, 0.0));
                            break;
                        }
                        block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(0.0, offset, 0.0)));
                        if (PlayerTeleportation.isValidBeeHive(block)) {
                            hitHive = true;
                            hivePos = new BlockPos(hitBlockPos.func_72441_c(0.0, offset, 0.0));
                            break;
                        }
                        block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(0.0, 0.0, offset)));
                        if (!PlayerTeleportation.isValidBeeHive(block)) continue;
                        hitHive = true;
                        hivePos = new BlockPos(hitBlockPos.func_72441_c(0.0, 0.0, offset));
                        break;
                    }
                    validBelowBlock = false;
                    String requiredBlockString = Bumblezone.BzDimensionConfig.requiredBlockUnderHive.get();
                    if (requiredBlockString.trim().isEmpty()) break block11;
                    if (requiredBlockString.matches("[a-z0-9/._-]+:[a-z0-9/._-]+") && Registry.field_212618_g.func_212607_c(new ResourceLocation(requiredBlockString))) {
                        Block requiredBlock = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(requiredBlockString));
                        if (requiredBlock == world.func_180495_p(hivePos.func_177977_b()).func_177230_c()) {
                            validBelowBlock = true;
                            break block9;
                        } else if (Bumblezone.BzDimensionConfig.warnPlayersOfWrongBlockUnderHive.get().booleanValue()) {
                            String beeBlock = Registry.field_212618_g.func_177774_c((Object)world.func_180495_p(hivePos).func_177230_c()).toString();
                            Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: The block under the " + beeBlock + " is not the correct block to teleport to Bumblezone. The config enter says it needs " + requiredBlockString + " under " + beeBlock + ".");
                            StringTextComponent message = new StringTextComponent("The config entry says it needs \u00c2\u00a76" + requiredBlockString + "\u00c2\u00a7f under \u00c2\u00a76" + beeBlock + "\u00c2\u00a7f.");
                            playerEntity.func_146105_b((ITextComponent)message, true);
                            return false;
                        }
                        break block9;
                    } else {
                        Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: The required block under beenest config is broken. Please specify a resourcelocation to a real block or leave it blank so that players can teleport to Bumblezone dimension. Currently, the broken config has this in it: " + requiredBlockString);
                        StringTextComponent message = new StringTextComponent("\u00c2\u00a7eBumblezone:\u00c2\u00a7f The required block under beenest config is broken. Please specify a resourcelocation to a real block or leave it blank so that players can teleport to Bumblezone dimension. Currently, the broken config has this in it: \u00c2\u00a7c" + requiredBlockString);
                        playerEntity.func_146105_b((ITextComponent)message, true);
                        return false;
                    }
                }
                validBelowBlock = true;
            }
            if (hitHive && validBelowBlock && !playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                cap.setTeleporting(true);
                return true;
            }
        }
        return false;
    }

    private static boolean isValidBeeHive(BlockState block) {
        if (block.func_177230_c() instanceof BeehiveBlock && (Bumblezone.BzDimensionConfig.allowTeleportationWithModdedBeehives.get().booleanValue() || block.func_177230_c().getRegistryName().func_110624_b().equals("minecraft"))) {
            return true;
        }
        if (ModChecker.productiveBeesPresent && Bumblezone.BzDimensionConfig.allowTeleportationWithModdedBeehives.get().booleanValue()) {
            return ProductiveBeesRedirection.PBIsAdvancedBeehiveAbstractBlock(block);
        }
        return false;
    }

    public static void playerLeavingBz(ResourceLocation dimensionLeaving, ServerPlayerEntity serverPlayerEntity) {
        if (!dimensionLeaving.equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)serverPlayerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            cap.setNonBZDim(dimensionLeaving);
        }
    }

    @Mod.EventBusSubscriber(modid="the_bumblezone")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void entityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
            if (event.getEntity() instanceof ServerPlayerEntity) {
                PlayerTeleportation.playerLeavingBz(event.getDimension().func_240901_a_(), (ServerPlayerEntity)event.getEntity());
            }
        }
    }
}

