/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.entities.BzEntities;
import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveHelperController;
import com.telepathicgrunt.the_bumblezone.entities.goals.BreedGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.FaceRandomGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.FacingRevengeGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.FloatGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HopGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.TemptGoal;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HoneySlimeEntity
extends AnimalEntity
implements IAngerable,
IMob {
    private static final DataParameter<Boolean> IN_HONEY = EntityDataManager.func_187226_a(HoneySlimeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> IN_HONEY_GROWTH_TIME = EntityDataManager.func_187226_a(HoneySlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient BREEDING_ITEM = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT});
    private static final DataParameter<Integer> ANGRY_TIMER = EntityDataManager.func_187226_a(HoneySlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger MAX_ANGER_DURATION = TickRangeConverter.func_233037_a_((int)10, (int)22);
    private UUID target_UUID;
    private static final HashSet<Block> HONEY_BASED_BLOCKS = Stream.of(Blocks.field_226907_mc_, BzBlocks.FILLED_POROUS_HONEYCOMB, BzBlocks.HONEYCOMB_BROOD, BzBlocks.STICKY_HONEY_REDSTONE, BzBlocks.STICKY_HONEY_RESIDUE).collect(Collectors.toCollection(HashSet::new));
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public HoneySlimeEntity(World worldIn) {
        super(BzEntities.HONEY_SLIME, worldIn);
    }

    public HoneySlimeEntity(EntityType<? extends HoneySlimeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new HoneySlimeMoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FacingRevengeGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal(this, 1.2, BREEDING_ITEM));
        this.field_70714_bg.func_75776_a(4, (Goal)new HopGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FaceRandomGoal(this));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setSlimeSize(2, true);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_HONEY, (Object)false);
        this.field_70180_af.func_187214_a(IN_HONEY_GROWTH_TIME, (Object)0);
        this.field_70180_af.func_187214_a(ANGRY_TIMER, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        this.func_213323_x_();
        this.field_70177_z = this.field_70759_as;
        this.field_70761_aq = this.field_70759_as;
        if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
            this.func_71061_d_();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("inHoney", this.isInHoney());
        compound.func_74768_a("inHoneyGrowthTimer", this.getInHoneyGrowthTime());
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setInHoney(compound.func_74767_n("inHoney"));
        this.setInHoneyGrowthTime(compound.func_74762_e("inHoneyGrowthTimer"));
        this.wasOnGround = compound.func_74767_n("wasOnGround");
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 2.0).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public boolean func_213380_a(IWorld world, SpawnReason spawnReason) {
        return true;
    }

    protected void setSlimeSize(int size, boolean resetHealth) {
        this.func_226264_Z_();
        this.func_213323_x_();
        Objects.requireNonNull(this.func_110148_a(Attributes.field_233818_a_)).func_111128_a((double)(size * size));
        Objects.requireNonNull(this.func_110148_a(Attributes.field_233821_d_)).func_111128_a((double)((0.2f + 0.1f * (float)size) * 2.0f));
        Objects.requireNonNull(this.func_110148_a(Attributes.field_233823_f_)).func_111128_a((double)size);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
    }

    public boolean isInHoney() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_HONEY);
    }

    public void setInHoney(boolean value) {
        this.field_70180_af.func_187227_b(IN_HONEY, (Object)value);
    }

    public int getInHoneyGrowthTime() {
        return (Integer)this.field_70180_af.func_187225_a(IN_HONEY_GROWTH_TIME);
    }

    public void setInHoneyGrowthTime(int value) {
        this.field_70180_af.func_187227_b(IN_HONEY_GROWTH_TIME, (Object)value);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        World world = player.func_130014_f_();
        if (!this.func_70631_g_() && this.isInHoney() && itemstack.func_77973_b() == Items.field_151069_bo) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_226638_pX_));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                    player.func_71019_a(new ItemStack((IItemProvider)Items.field_226638_pX_), false);
                }
            }
            this.func_70604_c((LivingEntity)player);
            this.getHoneyFromSlime((LivingEntity)this);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void getHoneyFromSlime(LivingEntity entity) {
        if (entity instanceof HoneySlimeEntity) {
            this.setInHoney(false);
            this.setInHoneyGrowthTime(-14400);
        }
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = 2;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Blocks.field_226907_mc_)), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            if (!this.isInHoney()) {
                this.setInHoneyGrowthTime(this.getInHoneyGrowthTime() + 1);
                if (!this.field_70170_p.field_72995_K && HONEY_BASED_BLOCKS.contains(this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c()) && (double)this.field_70146_Z.nextFloat() < 0.001) {
                    this.setInHoneyGrowthTime(0);
                }
            }
            this.setInHoney(this.getInHoneyGrowthTime() >= 0);
        }
    }

    protected void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, false);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEM.test(stack);
    }

    public AgeableEntity func_241840_a(ServerWorld worldIn, AgeableEntity ageable) {
        HoneySlimeEntity childHoneySlimeEntity = (HoneySlimeEntity)BzEntities.HONEY_SLIME.func_200721_a((World)worldIn);
        if (childHoneySlimeEntity != null) {
            childHoneySlimeEntity.setSlimeSize(1, true);
        }
        return childHoneySlimeEntity;
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_()) {
            this.setSlimeSize(2, true);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.func_70089_S()) {
            int i = 2;
            if (this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l((Entity)entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.getAttackStrength())) {
                this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    public boolean canDamagePlayer() {
        return !this.func_70631_g_() && this.func_70613_aW();
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.canDamagePlayer() && this.func_70638_az() == entityIn) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    public EntityType<? extends HoneySlimeEntity> func_200600_R() {
        return super.func_200600_R();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.field_70717_bb != player;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected float getAttackStrength() {
        return (float)Objects.requireNonNull(this.func_110148_a(Attributes.field_233823_f_)).func_111126_e();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70631_g_() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected SoundEvent getSquishSound() {
        return this.func_70631_g_() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    protected ResourceLocation func_184647_J() {
        return this.func_70631_g_() ? this.func_200600_R().func_220348_g() : LootTables.field_186419_a;
    }

    public float func_70599_aP() {
        return 0.4f * (float)(this.func_70631_g_() ? 1 : 2);
    }

    public int func_70646_bf() {
        return 0;
    }

    public boolean makesSoundOnJump() {
        return !this.func_70631_g_();
    }

    protected void func_70664_aZ() {
        Vector3d vec3d = this.func_213322_ci();
        this.func_70016_h(vec3d.field_72450_a, this.func_175134_bD(), vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    public SoundEvent getJumpSound() {
        return this.func_70631_g_() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGRY_TIMER);
    }

    public void func_230260_a__(int ticks) {
        this.field_70180_af.func_187227_b(ANGRY_TIMER, (Object)ticks);
    }

    public UUID func_230257_G__() {
        return this.target_UUID;
    }

    public void func_230259_a_(UUID uuid) {
        this.target_UUID = uuid;
    }

    public void func_230258_H__() {
        if (MAX_ANGER_DURATION != null) {
            this.func_230260_a__(MAX_ANGER_DURATION.func_233018_a_(this.field_70146_Z));
        }
    }
}

