/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.features;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.mixin.TemplateInvoker;
import com.telepathicgrunt.the_bumblezone.modCompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modCompat.ProductiveBeesRedirection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BeeDungeon
extends Feature<NoFeatureConfig> {
    private static final BlockState HONEY_CRYSTAL = BzBlocks.HONEY_CRYSTAL.func_176223_P();

    public BeeDungeon(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        if (Bumblezone.BzDungeonsConfig.beeDungeonRarity.get() >= 1000 || random.nextInt(Bumblezone.BzDungeonsConfig.beeDungeonRarity.get()) != 0) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position).func_196234_d(-3, -2, -3);
        return this.generateShell((IServerWorld)world, blockpos$Mutable);
    }

    protected boolean generateShell(IServerWorld world, BlockPos.Mutable blockpos$Mutable) {
        TemplateManager structureManager = world.func_201672_e().func_184163_y();
        Template structure = structureManager.func_200220_a(new ResourceLocation("the_bumblezone:bee_dungeon/shell"));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null);
        this.addBlocksToWorld(structure, world, (BlockPos)blockpos$Mutable, placementsettings, 2);
        structure = structureManager.func_200220_a(new ResourceLocation("the_bumblezone:bee_dungeon/altar"));
        this.addBlocksToWorld(structure, world, (BlockPos)blockpos$Mutable.func_196234_d(0, 1, 0), placementsettings, 2);
        return true;
    }

    public void addBlocksToWorld(Template structure, IServerWorld world, BlockPos pos, PlacementSettings placementIn, int flags) {
        List list;
        TemplateInvoker structureAccessor = (TemplateInvoker)structure;
        if (!(structureAccessor.getBlocks().isEmpty() || (list = placementIn.func_237132_a_(structureAccessor.getBlocks(), pos).func_237157_a_()).isEmpty() && (placementIn.func_186221_e() || structureAccessor.getEntities().isEmpty()) || structureAccessor.getSize().func_177958_n() < 1 || structureAccessor.getSize().func_177956_o() < 1 || structureAccessor.getSize().func_177952_p() < 1)) {
            MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int x = Integer.MAX_VALUE;
            int y = Integer.MAX_VALUE;
            int z = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (Template.BlockInfo template$blockinfo : Template.func_237145_a_((IWorld)world, (BlockPos)pos, (BlockPos)pos, (PlacementSettings)placementIn, (List)list)) {
                TileEntity blockentity1;
                BlockPos blockpos = template$blockinfo.field_186242_a;
                if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vector3i)blockpos)) continue;
                FluidState ifluidstate = placementIn.func_204763_l() ? world.func_204610_c(blockpos) : null;
                BlockState blockstate = template$blockinfo.field_186243_b.func_185902_a(placementIn.func_186212_b()).func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo.field_186244_c != null) {
                    TileEntity blockentity = world.func_175625_s(blockpos);
                    IClearable.func_213131_a((Object)blockentity);
                    world.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 20);
                }
                Pair<BlockState, Boolean> pair = BeeDungeon.blockConversion(world, blockpos, blockstate.func_177230_c(), world.func_201674_k());
                blockstate = (BlockState)pair.getFirst();
                if (!((Boolean)pair.getSecond()).booleanValue() && !world.func_180495_p(blockpos).func_200132_m() || !world.func_180501_a(blockpos, blockstate, flags)) continue;
                x = Math.min(x, blockpos.func_177958_n());
                y = Math.min(y, blockpos.func_177956_o());
                z = Math.min(z, blockpos.func_177952_p());
                l = Math.max(l, blockpos.func_177958_n());
                i1 = Math.max(i1, blockpos.func_177956_o());
                j1 = Math.max(j1, blockpos.func_177952_p());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.field_186244_c));
                if (template$blockinfo.field_186244_c != null && (blockentity1 = world.func_175625_s(blockpos)) != null) {
                    template$blockinfo.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    blockentity1.func_230337_a_(template$blockinfo.field_186243_b, template$blockinfo.field_186244_c);
                    blockentity1.func_189668_a(placementIn.func_186212_b());
                    blockentity1.func_189667_a(placementIn.func_186215_c());
                }
                if (ifluidstate == null || !(blockstate.func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)world, blockpos, blockstate, ifluidstate);
                if (ifluidstate.func_206889_d()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState ifluidstate2 = world.func_204610_c(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !ifluidstate2.func_206889_d(); ++k1) {
                        BlockPos blockpos1 = blockpos3.func_177972_a(adirection[k1]);
                        FluidState ifluidstate1 = world.func_204610_c(blockpos1);
                        if (!(ifluidstate1.func_215679_a((IBlockReader)world, blockpos1) > ifluidstate2.func_215679_a((IBlockReader)world, blockpos3)) && (!ifluidstate1.func_206889_d() || ifluidstate2.func_206889_d())) continue;
                        ifluidstate2 = ifluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!ifluidstate2.func_206889_d() || !((block = (blockstate2 = world.func_180495_p(blockpos2)).func_177230_c()) instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)block).func_204509_a((IWorld)world, blockpos2, blockstate2, ifluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (x <= l) {
                if (!placementIn.func_215218_i()) {
                    BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(l - x + 1, i1 - y + 1, j1 - z + 1);
                    BeeDungeon.setVoxelShapeParts(world, flags, list2, x, y, z, (VoxelShapePart)voxelshapepart);
                }
                BeeDungeon.placeBlocks(world, placementIn, flags, list2);
            }
            if (!placementIn.func_186221_e()) {
                structureAccessor.invokeSpawnEntities(world, pos, placementIn);
            }
        }
    }

    protected static void placeBlocks(IServerWorld world, PlacementSettings placementIn, int flags, List<Pair<BlockPos, CompoundNBT>> list2) {
        for (Pair<BlockPos, CompoundNBT> pair : list2) {
            TileEntity blockentity2;
            BlockPos blockpos4 = (BlockPos)pair.getFirst();
            if (!placementIn.func_215218_i()) {
                BlockState blockstate3;
                BlockState blockstate1 = world.func_180495_p(blockpos4);
                if (blockstate1 != (blockstate3 = Block.func_199770_b((BlockState)blockstate1, (IWorld)world, (BlockPos)blockpos4))) {
                    world.func_180501_a(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                }
                world.func_230547_a_(blockpos4, blockstate3.func_177230_c());
            }
            if (pair.getSecond() == null || (blockentity2 = world.func_175625_s(blockpos4)) == null) continue;
            blockentity2.func_70296_d();
        }
    }

    protected static void setVoxelShapeParts(IServerWorld world, int flags, List<Pair<BlockPos, CompoundNBT>> list2, int x, int y, int z, VoxelShapePart voxelshapepart) {
        for (Pair<BlockPos, CompoundNBT> pair1 : list2) {
            BlockPos blockpos5 = (BlockPos)pair1.getFirst();
            voxelshapepart.func_199625_a(blockpos5.func_177958_n() - x, blockpos5.func_177956_o() - y, blockpos5.func_177952_p() - z, true, true);
        }
        Template.func_222857_a((IWorld)world, (int)flags, (VoxelShapePart)voxelshapepart, (int)x, (int)y, (int)z);
    }

    private static Pair<BlockState, Boolean> blockConversion(IServerWorld world, BlockPos pos, Block block, Random random) {
        if (block == Blocks.field_196721_fC || block == Blocks.field_196795_fy) {
            if (ModChecker.productiveBeesPresent && (double)random.nextFloat() < Bumblezone.BzModCompatibilityConfig.PBOreHoneycombSpawnRateBeeDungeon.get()) {
                return new Pair((Object)ProductiveBeesRedirection.PBGetRandomHoneycomb(random, Bumblezone.BzModCompatibilityConfig.PBGreatHoneycombRarityBeeDungeon.get()).func_176223_P(), (Object)false);
            }
            if (random.nextFloat() < 0.4f) {
                return new Pair((Object)Blocks.field_226908_md_.func_176223_P(), (Object)false);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196778_fp) {
            if (random.nextFloat() < 0.6f) {
                return new Pair(((BlockState)BzBlocks.HONEYCOMB_BROOD.func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)Direction.SOUTH), (Object)false);
            }
            if (random.nextFloat() < 0.2f) {
                return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196783_fs) {
            if (random.nextFloat() < 0.6f) {
                return new Pair(((BlockState)BzBlocks.HONEYCOMB_BROOD.func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)Direction.WEST), (Object)false);
            }
            if (random.nextFloat() < 0.2f) {
                return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196785_ft) {
            if (random.nextFloat() < 0.6f) {
                return new Pair(((BlockState)BzBlocks.HONEYCOMB_BROOD.func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)Direction.NORTH), (Object)false);
            }
            if (random.nextFloat() < 0.2f) {
                return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196797_fz) {
            if (random.nextFloat() < 0.6f) {
                return new Pair(((BlockState)BzBlocks.HONEYCOMB_BROOD.func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)Direction.EAST), (Object)false);
            }
            if (random.nextFloat() < 0.2f) {
                return new Pair((Object)Blocks.field_226907_mc_.func_176223_P(), (Object)false);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)false);
        }
        if (block == BzBlocks.SUGAR_WATER_BLOCK) {
            if (random.nextFloat() < 0.1f && HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) {
                return new Pair(HONEY_CRYSTAL.func_206870_a((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true)), (Object)false);
            }
            return new Pair((Object)block.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196720_fB) {
            boolean replaceAir = false;
            if (world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_200132_m()) {
                replaceAir = true;
            }
            if (ModChecker.productiveBeesPresent && (double)random.nextFloat() < Bumblezone.BzModCompatibilityConfig.PBOreHoneycombSpawnRateBeeDungeon.get()) {
                return new Pair((Object)ProductiveBeesRedirection.PBGetRandomHoneycomb(random, Bumblezone.BzModCompatibilityConfig.PBGreatHoneycombRarityBeeDungeon.get()).func_176223_P(), (Object)replaceAir);
            }
            if (random.nextFloat() < 0.4f) {
                return new Pair((Object)Blocks.field_226908_md_.func_176223_P(), (Object)replaceAir);
            }
            return new Pair((Object)BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P(), (Object)replaceAir);
        }
        if (block == Blocks.field_196789_fv) {
            if (random.nextFloat() < 0.4f && HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) {
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            if (random.nextFloat() < 0.2f && HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) {
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196793_fx) {
            if (random.nextFloat() < 0.35f && HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) {
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
        }
        if (block == Blocks.field_196722_fD) {
            if (random.nextFloat() < 0.6f && HONEY_CRYSTAL.func_196955_c((IWorldReader)world, pos)) {
                return new Pair((Object)HONEY_CRYSTAL, (Object)true);
            }
            return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
        }
        return new Pair((Object)Blocks.field_201941_jj.func_176223_P(), (Object)false);
    }
}

