/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplexNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HoneycombCaves
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState FILLED_POROUS_HONEYCOMB = BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();
    private static final BlockState SUGAR_WATER = BzBlocks.SUGAR_WATER_BLOCK.func_176223_P();
    protected long seed;
    protected static OpenSimplexNoise noiseGen;
    protected static OpenSimplexNoise noiseGen2;
    private static final int[][] hexagon7;
    private static final int[][] hexagon6;
    private static final int[][] hexagon5;
    private static final int[][] hexagon4;
    private static final int[][] hexagon3;
    private static final int[][] hexagon2;
    private static final int[][] hexagon1;
    private static final int[][][] hexagonArray;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplexNoise(seed);
            noiseGen2 = new OpenSimplexNoise(seed + 1000L);
            this.seed = seed;
        }
    }

    public HoneycombCaves(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y < 241; ++y) {
                    mutableBlockPos.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    double noise1 = noiseGen.eval((double)mutableBlockPos.func_177958_n() * 0.02, (double)mutableBlockPos.func_177952_p() * 0.02, (double)mutableBlockPos.func_177956_o() * 0.04);
                    double noise2 = noiseGen2.eval((double)mutableBlockPos.func_177958_n() * 0.02, (double)mutableBlockPos.func_177952_p() * 0.02, (double)mutableBlockPos.func_177956_o() * 0.04);
                    double finalNoise = noise1 * noise1 + noise2 * noise2;
                    if (!(finalNoise < (double)9.0E-4f)) continue;
                    HoneycombCaves.hexagon(world, generator, (BlockPos)mutableBlockPos, random, noise1);
                }
            }
        }
        return true;
    }

    private static void hexagon(ISeedReader world, ChunkGenerator generator, BlockPos position, Random random, double noise) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        int index = (int)((noise * 0.5 + 0.5) * 7.0);
        for (int x = 0; x < 14; ++x) {
            for (int z = 0; z < 11; ++z) {
                int posResult = hexagonArray[index][z][x];
                if (posResult == 0) continue;
                BlockState blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vector3i)position).func_196234_d(x - 7, 0, z - 5));
                HoneycombCaves.carveAtBlock(world, generator, random, (BlockPos)mutableBlockPos, blockState, posResult);
                blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vector3i)position).func_196234_d(0, x - 7, z - 5));
                HoneycombCaves.carveAtBlock(world, generator, random, (BlockPos)mutableBlockPos, blockState, posResult);
                blockState = world.func_180495_p((BlockPos)mutableBlockPos.func_189533_g((Vector3i)position).func_196234_d(z - 5, x - 7, 0));
                HoneycombCaves.carveAtBlock(world, generator, random, (BlockPos)mutableBlockPos, blockState, posResult);
            }
        }
    }

    private static void carveAtBlock(ISeedReader world, ChunkGenerator generator, Random random, BlockPos blockPos, BlockState blockState, int posResult) {
        if (blockPos.func_177956_o() < generator.func_230356_f_() || !HoneycombCaves.isNextToLiquidOrAir(world, generator, blockPos)) {
            if (posResult == 2) {
                if (blockPos.func_177956_o() < 40) {
                    world.func_180501_a(blockPos, SUGAR_WATER, 3);
                } else {
                    world.func_180501_a(blockPos, CAVE_AIR, 3);
                }
            } else if (posResult == 1 && blockState.func_200132_m()) {
                if (random.nextInt(3) == 0) {
                    world.func_180501_a(blockPos, HONEYCOMB_BLOCK, 3);
                } else {
                    world.func_180501_a(blockPos, FILLED_POROUS_HONEYCOMB, 3);
                }
            }
        }
    }

    private static boolean isNextToLiquidOrAir(ISeedReader world, ChunkGenerator generator, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState blockState = world.func_180495_p(pos.func_177972_a(direction));
            if (pos.func_177972_a(direction).func_177956_o() < generator.func_230356_f_() || blockState != Blocks.field_150350_a.func_176223_P()) continue;
            return true;
        }
        return false;
    }

    static {
        hexagon7 = new int[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
        hexagon6 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon5 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon4 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon3 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon2 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon1 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagonArray = new int[][][]{hexagon1, hexagon2, hexagon3, hexagon4, hexagon5, hexagon6, hexagon7};
    }
}

