/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.generation;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.generation.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.generation.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.generation.layer.BzBiomeScalePillarLayer;
import com.telepathicgrunt.the_bumblezone.mixin.LayerAccessor;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BzBiomeProvider
extends BiomeProvider {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(bzBiomeProvider -> bzBiomeProvider.SEED), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(vanillaLayeredBiomeSource -> vanillaLayeredBiomeSource.BIOME_REGISTRY)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    private final Layer BIOME_SAMPLER;
    private final long SEED;
    private final Registry<Biome> BIOME_REGISTRY;
    public static Registry<Biome> layersBiomeRegistry;
    private static final List<RegistryKey<Biome>> BIOMES;

    public static void registerBiomeProvider() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("the_bumblezone", "biome_source"), CODEC);
    }

    public BzBiomeProvider(long seed, Registry<Biome> biomeRegistry) {
        super(BIOMES.stream().map(registryKey -> () -> (Biome)biomeRegistry.func_243576_d(registryKey)));
        BzBiomeLayer.setSeed(seed);
        this.SEED = seed;
        this.BIOME_REGISTRY = biomeRegistry;
        layersBiomeRegistry = biomeRegistry;
        this.BIOME_SAMPLER = BzBiomeProvider.buildWorldProcedure(seed);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> stack(long seed, IAreaTransformer1 parent, IAreaFactory<T> incomingArea, int count, LongFunction<C> contextFactory) {
        IAreaFactory IAreaFactory2 = incomingArea;
        for (int i = 0; i < count; ++i) {
            IAreaFactory2 = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), IAreaFactory2);
        }
        return IAreaFactory2;
    }

    public static Layer buildWorldProcedure(long seed) {
        IAreaFactory layerFactory = BzBiomeProvider.build(salt -> new LazyAreaLayerContext(25, seed, salt));
        return new Layer(layerFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> build(LongFunction<C> contextFactory) {
        IAreaFactory layer = BzBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        layer = BzBiomePillarLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1008L), layer);
        layer = BzBiomeScalePillarLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2523L), layer);
        return layer;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.sample(this.BIOME_REGISTRY, x, z);
    }

    public Biome sample(Registry<Biome> registry, int i, int j) {
        int k = ((LayerAccessor)this.BIOME_SAMPLER).getSampler().func_202678_a(i, j);
        Biome biome = (Biome)registry.func_148745_a(k);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + k));
            }
            return (Biome)registry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        }
        return biome;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new BzBiomeProvider(seed, this.BIOME_REGISTRY);
    }

    static {
        BIOMES = ImmutableList.of((Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("the_bumblezone", "hive_pillar")), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("the_bumblezone", "hive_wall")), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("the_bumblezone", "sugar_water_floor")));
    }
}

