/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.mixin.GenerationSettingsAccessor;
import com.telepathicgrunt.the_bumblezone.modCompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modCompat.ProductiveBeesRedirection;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Shadow
    @Final
    private Map<RegistryKey<World>, ServerWorld> field_71305_c;
    @Shadow
    @Final
    protected DynamicRegistries.Impl field_240767_f_;

    @Inject(method={"Lnet/minecraft/server/MinecraftServer;createWorlds(Lnet/minecraft/world/chunk/listener/IChunkStatusListener;)V"}, at={@At(value="TAIL")})
    private void onWorldCreation(CallbackInfo ci) {
        BeeAggression.setupBeeHatingList((World)this.field_71305_c.get(World.field_234918_g_));
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyBiomeRegistry(Thread p_i232576_1_, DynamicRegistries.Impl impl, SaveFormat.LevelSave p_i232576_3_, IServerConfiguration p_i232576_4_, ResourcePackList p_i232576_5_, Proxy p_i232576_6_, DataFixer p_i232576_7_, DataPackRegistries p_i232576_8_, MinecraftSessionService p_i232576_9_, GameProfileRepository p_i232576_10_, PlayerProfileCache p_i232576_11_, IChunkStatusListenerFactory p_i232576_12_, CallbackInfo ci) {
        boolean needToAddModCompatFeatures = ModChecker.productiveBeesPresent;
        if (needToAddModCompatFeatures && this.field_240767_f_.func_230521_a_(Registry.field_239720_u_).isPresent()) {
            for (ResourceLocation biomeRL : Bumblezone.BIOME_ID_LIST) {
                MinecraftServerMixin.addModdedFeatures(biomeRL, this.field_240767_f_);
            }
        }
    }

    private static void addModdedFeatures(ResourceLocation moddedBiomeRL, DynamicRegistries.Impl registryManager) {
        Biome biome = (Biome)((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_82594_a(moddedBiomeRL);
        if (biome == null) {
            Bumblezone.LOGGER.log(Level.WARN, "Error trying to add mod compat to : " + moddedBiomeRL + ". Please contact the Bumblezone developer TelepathicGrunt!");
            return;
        }
        List<List<Supplier<ConfiguredFeature<?, ?>>>> tempFeature = ((GenerationSettingsAccessor)biome.func_242440_e()).getGSFeatures();
        ArrayList mutableFeatures = new ArrayList();
        for (int i = 0; i < Math.max(10, tempFeature.size()); ++i) {
            if (i >= tempFeature.size()) {
                mutableFeatures.add(new ArrayList());
                continue;
            }
            mutableFeatures.add(new ArrayList(tempFeature.get(i)));
        }
        ((GenerationSettingsAccessor)biome.func_242440_e()).setGSFeatures(mutableFeatures);
        if (ModChecker.productiveBeesPresent && ((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_177774_c((Object)biome).func_110624_b().equals("the_bumblezone")) {
            ProductiveBeesRedirection.PBAddHoneycombs(biome);
        }
    }
}

