/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modCompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modCompat.PotionOfBeesCompat;
import com.telepathicgrunt.the_bumblezone.modCompat.ProductiveBeesCompat;
import java.util.concurrent.Callable;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Level;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean productiveBeesPresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "potionofbees";
            if (ModList.get().isLoaded(currentModID)) {
                ModChecker.runSetupForMod(() -> PotionOfBeesCompat::setupPotionOfBees);
            }
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
        try {
            currentModID = "productivebees";
            if (ModList.get().isLoaded(currentModID)) {
                ModChecker.runSetupForMod(() -> ProductiveBeesCompat::setupProductiveBees);
            }
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "ERROR: Something broke when trying to add mod compatibility with" + currentModID + ". Please let The Bumblezone developer (TelepathicGrunt) know about this!");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
    }

    public static void runSetupForMod(Callable<Runnable> toRun) throws Exception {
        toRun.call().run();
    }
}

