/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modCompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modCompat.ModChecker;
import cy.jdkdigital.productivebees.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.block.ExpansionBox;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class ProductiveBeesCompat {
    private static final String PRODUCTIVE_BEES_NAMESPACE = "productivebees";
    private static final List<Block> ORE_BASED_HONEYCOMB_VARIANTS = new ArrayList<Block>();
    public static List<EntityType<?>> PRODUCTIVE_BEES_LIST = new ArrayList();
    private static final List<Block> SPIDER_DUNGEON_HONEYCOMBS = new ArrayList<Block>();
    public static final RuleTest HONEYCOMB_BUMBLEZONE = new TagMatchRuleTest((ITag)BlockTags.func_199894_a((String)"the_bumblezone:honeycombs"));

    public static void setupProductiveBees() {
        ModChecker.productiveBeesPresent = true;
        for (EntityType productiveBeeType : ForgeRegistries.ENTITIES) {
            if (!productiveBeeType.getRegistryName().func_110624_b().equals(PRODUCTIVE_BEES_NAMESPACE) || !productiveBeeType.getRegistryName().func_110623_a().contains("bee")) continue;
            PRODUCTIVE_BEES_LIST.add(productiveBeeType);
        }
        if (Bumblezone.BzModCompatibilityConfig.spawnProductiveBeesHoneycombVariants.get().booleanValue()) {
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_bauxite")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_brazen")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_bronze")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_copper")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_rotten")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_slimy")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_radioactive")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees:comb_withered")));
            for (Block block : SPIDER_DUNGEON_HONEYCOMBS) {
                ProductiveBeesCompat.isBlockMissing(block, block.getRegistryName());
            }
        }
    }

    public static void PBAddHoneycombs(Biome biome) {
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_gold"), 34, 3, 6, 230, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_iron"), 26, 2, 30, 210, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_redstone"), 22, 1, 30, 210, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_lapis"), 22, 1, 6, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_emerald"), 5, 1, 6, 244, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_ender"), 5, 1, 200, 50, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_diamond"), 7, 1, 6, 244, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_blazing"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_glowing"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_bone"), 22, 1, 6, 25, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_fossilised"), 18, 1, 4, 20, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_draconic"), 5, 1, 200, 50, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_draconic"), 5, 1, 2, 10, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_powdery"), 7, 1, 60, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_quartz"), 7, 1, 60, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_magmatic"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_amber"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_electrum"), 30, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_invar"), 10, 1, 2, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_leaden"), 10, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_nickel"), 10, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_osmium"), 9, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_platinum"), 5, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_silver"), 9, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_steel"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_tin"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_titanium"), 6, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_tungsten"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(biome, new ResourceLocation("productivebees:comb_zinc"), 9, 1, 1, 200, false);
    }

    private static boolean isBlockMissing(Block block, ResourceLocation blockRL) {
        if (block == Blocks.field_150350_a) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: Error trying to get the following block: " + blockRL.toString() + ". Please let The Bumblezone developer know about this!");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return true;
        }
        return false;
    }

    private static void addCombToWorldgen(Biome biome, ResourceLocation blockRL, int veinSize, int count, int bottomOffset, int range, boolean addToHoneycombList) {
        Block honeycombBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockRL);
        if (ProductiveBeesCompat.isBlockMissing(honeycombBlock, blockRL)) {
            return;
        }
        ((List)biome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal())).add(() -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(HONEYCOMB_BUMBLEZONE, honeycombBlock.func_176223_P(), veinSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(bottomOffset, 0, range))).func_242728_a()).func_242731_b(count));
        if (addToHoneycombList) {
            ORE_BASED_HONEYCOMB_VARIANTS.add(honeycombBlock);
        }
    }

    public static boolean PBIsAdvancedBeehiveAbstractBlock(BlockState block) {
        if (block.func_177230_c() instanceof ExpansionBox && block.func_177229_b((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        return block.func_177230_c() instanceof AdvancedBeehiveAbstract;
    }

    public static void PBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (PRODUCTIVE_BEES_LIST.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of productive bees is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        IServerWorld world = (IServerWorld)event.getWorld();
        MobEntity productiveBeeEntity = (MobEntity)PRODUCTIVE_BEES_LIST.get(world.func_201674_k().nextInt(PRODUCTIVE_BEES_LIST.size())).func_200721_a(entity.field_70170_p);
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)entity.func_233580_cy_());
        productiveBeeEntity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        productiveBeeEntity.func_213386_a(world, world.func_175649_E(productiveBeeEntity.func_233580_cy_()), event.getSpawnReason(), null, null);
        world.func_217376_c((Entity)productiveBeeEntity);
    }

    public static Block PBGetRottenedHoneycomb(Random random) {
        Block replacementBlock = SPIDER_DUNGEON_HONEYCOMBS.get(random.nextInt(random.nextInt(SPIDER_DUNGEON_HONEYCOMBS.size()) + 1));
        return replacementBlock == Blocks.field_150350_a ? Blocks.field_226908_md_ : replacementBlock;
    }

    public static Block PBGetRandomHoneycomb(Random random, int lowerBoundBias) {
        int index = ORE_BASED_HONEYCOMB_VARIANTS.size() - 1;
        for (int i = 0; i < lowerBoundBias && index != 0; ++i) {
            index = random.nextInt(index + 1);
        }
        return ORE_BASED_HONEYCOMB_VARIANTS.get(index);
    }
}

