/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.surfacebuilders;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.BzBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class HoneySurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState FILLED_POROUS_HONEYCOMB = BzBlocks.FILLED_POROUS_HONEYCOMB.func_176223_P();
    private static final BlockState POROUS_HONEYCOMB = BzBlocks.POROUS_HONEYCOMB.func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();

    public HoneySurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        int xpos = x & 0xF;
        int zpos = z & 0xF;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int ypos = 255; ypos >= 0; --ypos) {
            blockpos$Mutable.func_181079_c(xpos, ypos, zpos);
            BlockState currentBlockState = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlockState.func_185904_a() == Material.field_151579_a) continue;
            if (currentBlockState == STONE) {
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, HONEYCOMB_BLOCK, false);
                continue;
            }
            if (currentBlockState == POROUS_HONEYCOMB) {
                if (!((double)ypos <= 42.0 + Math.max(noise, 0.0) + (double)random.nextInt(2))) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, FILLED_POROUS_HONEYCOMB, false);
                continue;
            }
            if (!currentBlockState.func_196958_f() || ypos >= 40) continue;
            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, defaultFluid, false);
        }
    }
}

