/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.dimension;

import com.google.common.primitives.Doubles;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.dimension.BzDimension;
import net.telepathicgrunt.bumblezone.entities.IPlayerComponent;
import net.telepathicgrunt.bumblezone.utils.BzPlacingUtils;
import org.apache.logging.log4j.Level;

public class BzPlayerPlacement {
    public static void enteringBumblezone(class_1297 entity) {
        if (entity instanceof class_3222) {
            MinecraftServer minecraftServer = entity.method_5682();
            class_3218 bumblezoneWorld = minecraftServer.method_3847(BzDimension.BZ_WORLD_KEY);
            class_5321 world_key = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)entity)).getNonBZDimension());
            if (bumblezoneWorld == null) {
                Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                class_2585 message = new class_2585("Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: \u00a76https://bugs.mojang.com/browse/MC-195468\u00a7f. A restart will fix this.");
                ((class_3222)entity).method_7353((class_2561)message, true);
                return;
            }
            class_243 destinationPosition = BzPlayerPlacement.teleportByPearl((class_1657)entity, minecraftServer.method_3847(world_key), bumblezoneWorld);
            ((class_3222)entity).method_14251(bumblezoneWorld, destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.field_6031, entity.field_5965);
        }
    }

    public static void exitingBumblezone(class_1297 entity, class_3218 destination) {
        boolean upwardChecking;
        boolean bl = upwardChecking = entity.method_23318() > 0.0;
        if (entity instanceof class_3222) {
            ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)entity)).setNonBZPos(entity.method_19538());
            class_243 destinationPosition = BzPlayerPlacement.teleportByOutOfBounds((class_1657)entity, destination, upwardChecking);
            ((class_3222)entity).method_14251(destination, destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.field_6031, entity.field_5965);
        }
    }

    private static class_243 teleportByOutOfBounds(class_1657 playerEntity, class_3218 destination, boolean checkingUpward) {
        class_2338 blockpos;
        double coordinateScale = destination.method_8597().method_31110();
        class_2338 validBlockPos = null;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode != 2 || ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)playerEntity)).getNonBZPos() == null) {
            blockpos = new class_2338(Doubles.constrainToRange((double)(playerEntity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), playerEntity.method_19538().method_10214(), Doubles.constrainToRange((double)(playerEntity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = BzPlayerPlacement.validPlayerSpawnLocationByBeehive((class_1937)destination, blockpos, 48, checkingUpward);
        } else {
            blockpos = new class_2338(playerEntity.method_19538());
        }
        if ((Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 2 || Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 3 && validBlockPos == null) && destination.method_8320((validBlockPos = ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)playerEntity)).getNonBZPos() == null ? blockpos : new class_2338(((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)playerEntity)).getNonBZPos())).method_10084()).method_26225()) {
            destination.method_8652(validBlockPos, class_2246.field_10124.method_9564(), 3);
            destination.method_8652(validBlockPos.method_10084(), class_2246.field_10124.method_9564(), 3);
        }
        return new class_243((double)validBlockPos.method_10263() + 0.5, (double)(validBlockPos.method_10264() + 1), (double)validBlockPos.method_10260() + 0.5);
    }

    private static class_243 teleportByPearl(class_1657 playerEntity, class_3218 originalWorld, class_3218 bumblezoneWorld) {
        int heightCheck;
        double coordinateScale = originalWorld.method_8597().method_31110();
        class_2338 blockpos = new class_2338(playerEntity.method_19538().method_10216() * coordinateScale, playerEntity.method_19538().method_10214(), playerEntity.method_19538().method_10215() * coordinateScale);
        Object validBlockPos = BzPlayerPlacement.validPlayerSpawnLocation((class_1937)bumblezoneWorld, blockpos, 10);
        if (validBlockPos == null) {
            validBlockPos = new class_2338(blockpos.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((class_1936)bumblezoneWorld, blockpos.method_10264(), 0, blockpos) + 1, blockpos.method_10260());
            if (validBlockPos.method_10264() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.method_8320(validBlockPos).method_26207() == class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() == class_3614.field_15920) {
                class_2338.class_2339 mutable = new class_2338.class_2339(validBlockPos.method_10263(), validBlockPos.method_10264(), validBlockPos.method_10260());
                while (mutable.method_10264() < 255 && !bumblezoneWorld.method_22347((class_2338)mutable) || bumblezoneWorld.method_8320((class_2338)mutable).method_26207() == class_3614.field_15920) {
                    mutable.method_10098(class_2350.field_11036);
                }
                validBlockPos = bumblezoneWorld.method_8320((class_2338)mutable).method_26207() != class_3614.field_15959 ? null : mutable;
            } else if (!bumblezoneWorld.method_22347(validBlockPos) && bumblezoneWorld.method_8320(validBlockPos).method_26207() != class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() != class_3614.field_15959) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.method_8501(blockpos, class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084(), class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10074(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072().method_10084(), class_2246.field_21212.method_9564());
                validBlockPos = blockpos;
            }
        }
        if (playerEntity.method_6113()) {
            playerEntity.method_18400();
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.method_10264() && bumblezoneWorld.method_8320(validBlockPos.method_10087(heightCheck)).method_26215(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.method_10264()) {
            bumblezoneWorld.method_8501(validBlockPos.method_10264() == 0 ? validBlockPos : validBlockPos.method_10074(), class_2246.field_21212.method_9564());
        }
        return new class_243((double)validBlockPos.method_10263() + 0.5, (double)validBlockPos.method_10264(), (double)validBlockPos.method_10260() + 0.5);
    }

    private static class_2338 validPlayerSpawnLocationByBeehive(class_1937 world, class_2338 position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        int halfRange = maximumRange / 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = -halfRange; x < halfRange; ++x) {
            for (int z = -halfRange; z < halfRange; ++z) {
                mutableBlockPos.method_10103(position.method_10263() + x, 0, position.method_10260() + z);
                if (!world.method_8393(mutableBlockPos.method_10263() >> 4, mutableBlockPos.method_10260() >> 4)) {
                    world.method_22350((class_2338)mutableBlockPos);
                }
                maxHeight = Math.max(maxHeight, world.method_8624(class_2902.class_2903.field_13197, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()));
            }
        }
        maxHeight = Math.min(maxHeight, world.method_8322() - 1);
        mutableBlockPos.method_10103(position.method_10263(), checkingUpward ? 0 : maxHeight, position.method_10260());
        while (mutableBlockPos.method_10264() >= 0 && mutableBlockPos.method_10264() <= maxHeight) {
            if (!Bumblezone.BZ_CONFIG.BZDimensionConfig.seaLevelOrHigherExitTeleporting || mutableBlockPos.method_10264() > world.method_8615()) {
                for (int range = 0; range < maximumRange; ++range) {
                    int radius = range * range;
                    int nextRadius = (range + 1) * (range + 1);
                    for (int x = 0; x <= range * 2; ++x) {
                        int x2 = x > range ? -(x - range) : x;
                        for (int z = 0; z <= range * 2; ++z) {
                            class_2338 validSpot;
                            int z2;
                            int n = z2 = z > range ? -(z - range) : x;
                            if (x2 * x2 + z2 * z2 < radius || x2 * x2 + z2 * z2 >= nextRadius) continue;
                            mutableBlockPos.method_10103(position.method_10263() + x2, mutableBlockPos.method_10264(), position.method_10260() + z2);
                            if (world.method_8320((class_2338)mutableBlockPos).method_26204() != class_2246.field_20421 || (validSpot = BzPlayerPlacement.validPlayerSpawnLocation(world, (class_2338)mutableBlockPos, 4)) == null) continue;
                            return validSpot;
                        }
                    }
                }
            }
            if (checkingUpward) {
                mutableBlockPos.method_10098(class_2350.field_11036);
                continue;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 3) {
            return null;
        }
        if (maxHeight + 1 < world.method_8322()) {
            ++maxHeight;
        }
        mutableBlockPos.method_10103(position.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeight((class_1936)world, maxHeight, 0, position), position.method_10260());
        if (mutableBlockPos.method_10264() <= 0) {
            mutableBlockPos.method_10103(position.method_10263(), world.method_8322() / 2, position.method_10260());
        }
        BzPlayerPlacement.createSpaceForPlayer(world, mutableBlockPos);
        return mutableBlockPos;
    }

    private static void createSpaceForPlayer(class_1937 world, class_2338.class_2339 mutableBlockPos) {
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.generateBeenest) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_20421.method_9564());
        } else if (world.method_8320((class_2338)mutableBlockPos).method_26207() == class_3614.field_15959 || !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15769() && !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15767((class_3494)class_3486.field_15517)) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_21212.method_9564());
        }
        world.method_8501(mutableBlockPos.method_10084(), class_2246.field_10124.method_9564());
    }

    private static class_2338 validPlayerSpawnLocation(class_1937 world, class_2338 position, int maximumRange) {
        class_2338.class_2339 currentPos = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        for (int range = 0; range < maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        int distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.method_10101((class_2382)position.method_10069(x2, y2, z2));
                        if (!world.method_8320(currentPos.method_10074()).method_26225() || world.method_8320((class_2338)currentPos).method_26207() != class_3614.field_15959 || world.method_8320(currentPos.method_10084()).method_26207() != class_3614.field_15959) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

