/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.generation;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.LongFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3625;
import net.minecraft.class_3627;
import net.minecraft.class_3628;
import net.minecraft.class_3631;
import net.minecraft.class_3642;
import net.minecraft.class_3656;
import net.minecraft.class_3660;
import net.minecraft.class_5321;
import net.minecraft.class_5504;
import net.minecraft.class_5505;
import net.telepathicgrunt.bumblezone.generation.layer.BzBiomeLayer;
import net.telepathicgrunt.bumblezone.generation.layer.BzBiomePillarLayer;
import net.telepathicgrunt.bumblezone.generation.layer.BzBiomeScalePillarLayer;
import net.telepathicgrunt.bumblezone.mixin.BiomeLayerSamplerAccessor;

public class BzBiomeProvider
extends class_1966 {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(bzBiomeProvider -> bzBiomeProvider.SEED), (App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(vanillaLayeredBiomeSource -> vanillaLayeredBiomeSource.BIOME_REGISTRY)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    private final class_3642 BIOME_SAMPLER;
    private final long SEED;
    private final class_2378<class_1959> BIOME_REGISTRY;
    public static class_2378<class_1959> layersBiomeRegistry;
    private static final List<class_5321<class_1959>> BIOMES;

    public static void registerBiomeProvider() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("the_bumblezone", "biome_source"), CODEC);
    }

    public BzBiomeProvider(long seed, class_2378<class_1959> biomeRegistry) {
        super(BIOMES.stream().map(registryKey -> () -> (class_1959)biomeRegistry.method_31140(registryKey)));
        BzBiomeLayer.setSeed(seed);
        this.SEED = seed;
        this.BIOME_REGISTRY = biomeRegistry;
        layersBiomeRegistry = biomeRegistry;
        this.BIOME_SAMPLER = BzBiomeProvider.buildWorldProcedure(seed);
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> stack(long seed, class_3660 parent, class_3627<T> incomingArea, int count, LongFunction<C> contextFactory) {
        class_3627 LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.method_15862((class_3628)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static class_3642 buildWorldProcedure(long seed) {
        class_3627 layerFactory = BzBiomeProvider.build(salt -> new class_3631(25, seed, salt));
        return new class_3642(layerFactory);
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> build(LongFunction<C> contextFactory) {
        class_3627 layer = BzBiomeLayer.INSTANCE.method_15854((class_3628)contextFactory.apply(200L));
        layer = BzBiomePillarLayer.INSTANCE.method_15862((class_3628)contextFactory.apply(1008L), layer);
        layer = BzBiomeScalePillarLayer.INSTANCE.method_15862((class_3628)contextFactory.apply(1055L), layer);
        layer = class_3656.field_16198.method_15862((class_3628)contextFactory.apply(2003L), layer);
        layer = class_3656.field_16198.method_15862((class_3628)contextFactory.apply(2523L), layer);
        return layer;
    }

    public class_1959 method_16359(int x, int y, int z) {
        return this.sample(this.BIOME_REGISTRY, x, z);
    }

    public class_1959 sample(class_2378<class_1959> registry, int i, int j) {
        int k = ((BiomeLayerSamplerAccessor)this.BIOME_SAMPLER).getSampler().method_15825(i, j);
        class_1959 biome = (class_1959)registry.method_10200(k);
        if (biome == null) {
            if (class_155.field_1125) {
                throw (IllegalStateException)class_156.method_22320((Throwable)new IllegalStateException("Unknown biome id: " + k));
            }
            return (class_1959)registry.method_29107(class_5504.method_31144((int)0));
        }
        return biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1966 method_27985(long seed) {
        return new BzBiomeProvider(seed, this.BIOME_REGISTRY);
    }

    static {
        BIOMES = ImmutableList.of((Object)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("the_bumblezone", "hive_pillar")), (Object)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("the_bumblezone", "hive_wall")), (Object)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("the_bumblezone", "sugar_water_floor")));
    }
}

