/*
 * Decompiled with CFR 0.152.
 */
package com.parakeetmod.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.parakeetmod.entities.ParakeetEntity;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParakeetEntityModel
extends SegmentedModel<ParakeetEntity> {
    private final ModelRenderer body;
    private final ModelRenderer tail;
    private final ModelRenderer wingLeft;
    private final ModelRenderer wingRight;
    private final ModelRenderer head;
    private final ModelRenderer head2;
    private final ModelRenderer beak1;
    private final ModelRenderer beak2;
    private final ModelRenderer feather;
    private final ModelRenderer legLeft;
    private final ModelRenderer legRight;

    public ParakeetEntityModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((Model)this, 2, 8);
        this.body.func_228300_a_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f);
        this.body.func_78793_a(0.0f, 16.5f, -3.0f);
        this.tail = new ModelRenderer((Model)this, 22, 1);
        this.tail.func_228300_a_(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 1.0f);
        this.tail.func_78793_a(0.0f, 21.07f, 1.16f);
        this.wingLeft = new ModelRenderer((Model)this, 19, 8);
        this.wingLeft.func_228300_a_(-0.5f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingLeft.func_78793_a(1.5f, 16.94f, -2.76f);
        this.wingRight = new ModelRenderer((Model)this, 19, 8);
        this.wingRight.func_228300_a_(-0.5f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingRight.func_78793_a(-1.5f, 16.94f, -2.76f);
        this.head = new ModelRenderer((Model)this, 2, 2);
        this.head.func_228300_a_(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        this.head.func_78793_a(0.0f, 15.69f, -2.76f);
        this.head2 = new ModelRenderer((Model)this, 10, 0);
        this.head2.func_228300_a_(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 4.0f);
        this.head2.func_78793_a(0.0f, -2.0f, -1.0f);
        this.head.func_78792_a(this.head2);
        this.beak1 = new ModelRenderer((Model)this, 11, 7);
        this.beak1.func_228300_a_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.beak1.func_78793_a(0.0f, -0.5f, -1.5f);
        this.head.func_78792_a(this.beak1);
        this.beak2 = new ModelRenderer((Model)this, 16, 7);
        this.beak2.func_228300_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.beak2.func_78793_a(0.0f, -1.75f, -2.45f);
        this.head.func_78792_a(this.beak2);
        this.feather = new ModelRenderer((Model)this, 2, 18);
        this.feather.func_228300_a_(0.0f, -4.0f, -2.0f, 0.0f, 5.0f, 4.0f);
        this.feather.func_78793_a(0.0f, -2.15f, 0.15f);
        this.head.func_78792_a(this.feather);
        this.legLeft = new ModelRenderer((Model)this, 14, 18);
        this.legLeft.func_228300_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legLeft.func_78793_a(1.0f, 22.0f, -1.05f);
        this.legRight = new ModelRenderer((Model)this, 14, 18);
        this.legRight.func_228300_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legRight.func_78793_a(-1.0f, 22.0f, -1.05f);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.body, (Object)this.wingLeft, (Object)this.wingRight, (Object)this.tail, (Object)this.head, (Object)this.legLeft, (Object)this.legRight);
    }

    public void setRotationAngles(ParakeetEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setRotationAngles(ParakeetEntityModel.getParakeetState(entityIn), entityIn.field_70173_aa, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void setLivingAnimations(ParakeetEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.setLivingAnimations(ParakeetEntityModel.getParakeetState(entityIn));
    }

    public void renderOnShoulder(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float p_228284_5_, float p_228284_6_, float p_228284_7_, float p_228284_8_, int p_228284_9_) {
        this.setLivingAnimations(State.ON_SHOULDER);
        this.setRotationAngles(State.ON_SHOULDER, p_228284_9_, p_228284_5_, p_228284_6_, 0.0f, p_228284_7_, p_228284_8_);
        this.func_225601_a_().forEach(p_228285_4_ -> p_228285_4_.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn));
    }

    private void setRotationAngles(State p_217162_1_, int p_217162_2_, float p_217162_3_, float p_217162_4_, float p_217162_5_, float p_217162_6_, float p_217162_7_) {
        this.head.field_78795_f = p_217162_7_ * ((float)Math.PI / 180);
        this.head.field_78796_g = p_217162_6_ * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        this.head.field_78800_c = 0.0f;
        this.body.field_78800_c = 0.0f;
        this.tail.field_78800_c = 0.0f;
        this.wingRight.field_78800_c = -1.5f;
        this.wingLeft.field_78800_c = 1.5f;
        switch (p_217162_1_) {
            case SITTING: {
                break;
            }
            case PARTY: {
                float f = MathHelper.func_76134_b((float)p_217162_2_);
                float f1 = MathHelper.func_76126_a((float)p_217162_2_);
                this.head.field_78800_c = f;
                this.head.field_78797_d = 15.69f + f1;
                this.head.field_78795_f = 0.0f;
                this.head.field_78796_g = 0.0f;
                this.head.field_78808_h = MathHelper.func_76126_a((float)p_217162_2_) * 0.4f;
                this.body.field_78800_c = f;
                this.body.field_78797_d = 16.5f + f1;
                this.wingLeft.field_78808_h = -0.0873f - p_217162_5_;
                this.wingLeft.field_78800_c = 1.5f + f;
                this.wingLeft.field_78797_d = 16.94f + f1;
                this.wingRight.field_78808_h = 0.0873f + p_217162_5_;
                this.wingRight.field_78800_c = -1.5f + f;
                this.wingRight.field_78797_d = 16.94f + f1;
                this.tail.field_78800_c = f;
                this.tail.field_78797_d = 21.07f + f1;
                break;
            }
            case STANDING: {
                this.legLeft.field_78795_f += MathHelper.func_76134_b((float)(p_217162_3_ * 0.6662f)) * 1.4f * p_217162_4_;
                this.legRight.field_78795_f += MathHelper.func_76134_b((float)(p_217162_3_ * 0.6662f + (float)Math.PI)) * 1.4f * p_217162_4_;
            }
            default: {
                float f2 = p_217162_5_ * 0.3f;
                this.head.field_78797_d = 15.69f + f2;
                this.tail.field_78795_f = 1.015f + MathHelper.func_76134_b((float)(p_217162_3_ * 0.6662f)) * 0.3f * p_217162_4_;
                this.tail.field_78797_d = 21.07f + f2;
                this.body.field_78797_d = 16.5f + f2;
                this.wingLeft.field_78808_h = -0.0873f - p_217162_5_;
                this.wingLeft.field_78797_d = 16.94f + f2;
                this.wingRight.field_78808_h = 0.0873f + p_217162_5_;
                this.wingRight.field_78797_d = 16.94f + f2;
                this.legLeft.field_78797_d = 22.0f + f2;
                this.legRight.field_78797_d = 22.0f + f2;
            }
        }
    }

    private void setLivingAnimations(State p_217160_1_) {
        this.feather.field_78795_f = -0.2214f;
        this.body.field_78795_f = 0.4937f;
        this.wingLeft.field_78795_f = -0.6981f;
        this.wingLeft.field_78796_g = (float)(-Math.PI);
        this.wingRight.field_78795_f = -0.6981f;
        this.wingRight.field_78796_g = (float)(-Math.PI);
        this.legLeft.field_78795_f = -0.0299f;
        this.legRight.field_78795_f = -0.0299f;
        this.legLeft.field_78797_d = 22.0f;
        this.legRight.field_78797_d = 22.0f;
        this.legLeft.field_78808_h = 0.0f;
        this.legRight.field_78808_h = 0.0f;
        switch (p_217160_1_) {
            case SITTING: {
                float f = 1.9f;
                this.head.field_78797_d = 17.59f;
                this.tail.field_78795_f = 1.5388988f;
                this.tail.field_78797_d = 22.97f;
                this.body.field_78797_d = 18.4f;
                this.wingLeft.field_78808_h = -0.0873f;
                this.wingLeft.field_78797_d = 18.84f;
                this.wingRight.field_78808_h = 0.0873f;
                this.wingRight.field_78797_d = 18.84f;
                this.legLeft.field_78797_d += 1.0f;
                this.legRight.field_78797_d += 1.0f;
                this.legLeft.field_78795_f += 1.0f;
                this.legRight.field_78795_f += 1.0f;
                break;
            }
            case PARTY: {
                this.legLeft.field_78808_h = -0.34906584f;
                this.legRight.field_78808_h = 0.34906584f;
            }
            default: {
                break;
            }
            case FLYING: {
                this.legLeft.field_78795_f += 0.6981317f;
                this.legRight.field_78795_f += 0.6981317f;
            }
        }
    }

    private static State getParakeetState(ParakeetEntity p_217158_0_) {
        if (p_217158_0_.isPartying()) {
            return State.PARTY;
        }
        if (p_217158_0_.func_233684_eK_()) {
            return State.SITTING;
        }
        return p_217158_0_.isFlying() ? State.FLYING : State.STANDING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        FLYING,
        STANDING,
        SITTING,
        PARTY,
        ON_SHOULDER;

    }
}

