/*
 * Decompiled with CFR 0.152.
 */
package javidg96.parakeetmod.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ParakeetEntity
extends ShoulderRidingEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(ParakeetEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Predicate<MobEntity> CAN_MIMIC = new Predicate<MobEntity>(){

        @Override
        public boolean test(@Nullable MobEntity p_test_1_) {
            return p_test_1_ != null && IMITATION_SOUND_EVENTS.containsKey(p_test_1_.func_200600_R());
        }
    };
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151034_e});
    private static final Item DEADLY_ITEM = Items.field_151106_aX;
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151080_bb});
    private static final Map<EntityType<?>, SoundEvent> IMITATION_SOUND_EVENTS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_200609_0_ -> {
        p_200609_0_.put(EntityType.field_200792_f, SoundEvents.field_193791_eM);
        p_200609_0_.put(EntityType.field_200794_h, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200797_k, SoundEvents.field_193792_eN);
        p_200609_0_.put(EntityType.field_204724_o, SoundEvents.field_206942_fI);
        p_200609_0_.put(EntityType.field_200800_n, SoundEvents.field_193793_eO);
        p_200609_0_.put(EntityType.field_200802_p, SoundEvents.field_193794_eP);
        p_200609_0_.put(EntityType.field_200804_r, SoundEvents.field_193796_eR);
        p_200609_0_.put(EntityType.field_200806_t, SoundEvents.field_193797_eS);
        p_200609_0_.put(EntityType.field_200811_y, SoundEvents.field_193798_eT);
        p_200609_0_.put(EntityType.field_200761_A, SoundEvents.field_219654_hI);
        p_200609_0_.put(EntityType.field_233588_G_, SoundEvents.field_232796_kj_);
        p_200609_0_.put(EntityType.field_200763_C, SoundEvents.field_193799_eU);
        p_200609_0_.put(EntityType.field_200764_D, SoundEvents.field_193800_eV);
        p_200609_0_.put(EntityType.field_200771_K, SoundEvents.field_193801_eW);
        p_200609_0_.put(EntityType.field_203097_aH, SoundEvents.field_206943_fS);
        p_200609_0_.put(EntityType.field_233591_ai_, SoundEvents.field_232797_ko_);
        p_200609_0_.put(EntityType.field_242287_aj, SoundEvents.field_242131_kp);
        p_200609_0_.put(EntityType.field_220350_aJ, SoundEvents.field_219656_hO);
        p_200609_0_.put(EntityType.field_220352_aU, SoundEvents.field_219657_hQ);
        p_200609_0_.put(EntityType.field_200738_ad, SoundEvents.field_193803_eY);
        p_200609_0_.put(EntityType.field_200740_af, SoundEvents.field_193804_eZ);
        p_200609_0_.put(EntityType.field_200741_ag, SoundEvents.field_193811_fa);
        p_200609_0_.put(EntityType.field_200743_ai, SoundEvents.field_193812_fb);
        p_200609_0_.put(EntityType.field_200748_an, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200750_ap, SoundEvents.field_193814_fd);
        p_200609_0_.put(EntityType.field_200755_au, SoundEvents.field_193815_fe);
        p_200609_0_.put(EntityType.field_200758_ax, SoundEvents.field_193816_ff);
        p_200609_0_.put(EntityType.field_200759_ay, SoundEvents.field_193817_fg);
        p_200609_0_.put(EntityType.field_200760_az, SoundEvents.field_193818_fh);
        p_200609_0_.put(EntityType.field_200722_aA, SoundEvents.field_193819_fi);
        p_200609_0_.put(EntityType.field_233590_aW_, SoundEvents.field_232786_kC_);
        p_200609_0_.put(EntityType.field_200725_aD, SoundEvents.field_193821_fk);
        p_200609_0_.put(EntityType.field_200727_aF, SoundEvents.field_193823_fm);
    });
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private boolean partyParakeet;
    private BlockPos jukeboxPosition;

    public ParakeetEntity(EntityType<? extends ParakeetEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setVariant(this.field_70146_Z.nextInt(7));
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(false);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableEntity createChild(AgeableEntity ageable) {
        return null;
    }

    public boolean func_70631_g_() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, ParakeetEntity.class, 2.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, ParrotEntity.class, 2.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute func_234213_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233822_e_, (double)0.4f).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.6f;
    }

    public void func_70636_d() {
        if (this.jukeboxPosition == null || !this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 3.46) || !this.field_70170_p.func_180495_p(this.jukeboxPosition).func_203425_a(Blocks.field_150421_aI)) {
            this.partyParakeet = false;
            this.jukeboxPosition = null;
        }
        if (this.field_70170_p.field_73012_v.nextInt(400) == 0) {
            ParakeetEntity.playMimicSound(this.field_70170_p, (Entity)this);
        }
        super.func_70636_d();
        this.calculateFlapping();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.partyParakeet = isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isPartying() {
        return this.partyParakeet;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.field_70122_E && !this.func_184218_aH() ? 4 : -1) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public static boolean playMimicSound(World worldIn, Entity parakeetIn) {
        if (parakeetIn.func_70089_S() && !parakeetIn.func_174814_R() && worldIn.field_73012_v.nextInt(2) == 0) {
            MobEntity mobentity;
            List list = worldIn.func_175647_a(MobEntity.class, parakeetIn.func_174813_aQ().func_186662_g(20.0), CAN_MIMIC);
            if (!list.isEmpty() && !(mobentity = (MobEntity)list.get(worldIn.field_73012_v.nextInt(list.size()))).func_174814_R()) {
                SoundEvent soundevent = ParakeetEntity.getMimicSound(mobentity.func_200600_R());
                worldIn.func_184148_a((PlayerEntity)null, parakeetIn.func_226277_ct_(), parakeetIn.func_226278_cu_(), parakeetIn.func_226281_cx_(), soundevent, parakeetIn.func_184176_by(), 0.7f, ParakeetEntity.getPitch(worldIn.field_73012_v));
                return true;
            }
            return false;
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (!this.func_70909_n() && TAME_ITEMS.contains(itemstack.func_77973_b())) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                    this.func_193101_c(p_230254_1_);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            if (this.field_70170_p.field_72995_K) {
                if (this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_)) {
                    return ActionResultType.SUCCESS;
                }
                return !this.func_70877_b(itemstack) || !(this.func_110143_aJ() < this.func_110138_aP()) && this.func_70909_n() ? ActionResultType.PASS : ActionResultType.SUCCESS;
            }
            if (this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_) && item.func_219971_r() && this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.CONSUME;
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (itemstack.func_77973_b() == DEADLY_ITEM) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_195064_c(new EffectInstance(Effects.field_76436_u, 900));
            if (p_230254_1_.func_184812_l_() || !this.func_190530_aW()) {
                this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)p_230254_1_), Float.MAX_VALUE);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.isFlying() && this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_233687_w_(!this.func_233685_eM_());
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    public static boolean func_223317_c(EntityType<ParakeetEntity> parakeetIn, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return ParakeetEntity.func_234212_a_(this.field_70170_p, this.field_70170_p.field_73012_v);
    }

    public static SoundEvent func_234212_a_(World p_234212_0_, Random p_234212_1_) {
        if (p_234212_0_.func_175659_aa() != Difficulty.PEACEFUL && p_234212_1_.nextInt(1000) == 0) {
            ArrayList list = Lists.newArrayList(IMITATION_SOUND_EVENTS.keySet());
            return ParakeetEntity.getMimicSound((EntityType)list.get(p_234212_1_.nextInt(list.size())));
        }
        return SoundEvents.field_192792_ep;
    }

    private static SoundEvent getMimicSound(EntityType<?> type) {
        return IMITATION_SOUND_EVENTS.getOrDefault(type, SoundEvents.field_192792_ep);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_192794_er;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float volume) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return volume + this.flapSpeed / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_70647_i() {
        return ParakeetEntity.getPitch(this.field_70146_Z);
    }

    public static float getPitch(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_233687_w_(false);
        return super.func_70097_a(source, amount);
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)6);
    }

    public void setVariant(int variantIn) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variantIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.5f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }
}

