/*
 * Decompiled with CFR 0.152.
 */
package net.parakeetmod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1360;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1395;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1453;
import net.minecraft.class_1471;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5425;
import net.minecraft.class_7;

public class ParakeetEntity
extends class_1471
implements class_1432 {
    private static final class_2940<Integer> ATTR_VARIANT = class_2945.method_12791(ParakeetEntity.class, (class_2941)class_2943.field_13327);
    private static final Predicate<class_1308> CAN_IMITATE = new Predicate<class_1308>(){

        @Override
        public boolean test(@Nullable class_1308 mobEntity) {
            return mobEntity != null && MOB_SOUNDS.containsKey(mobEntity.method_5864());
        }
    };
    private static final class_1792 COOKIE = class_1802.field_8423;
    private static final Set<class_1792> TAMING_INGREDIENTS = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8317, class_1802.field_8706});
    private static final class_1856 BREEDING_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8279, class_1802.field_8179});
    private static final Map<class_1299<?>, class_3414> MOB_SOUNDS = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(class_1299.field_6099, class_3417.field_15199);
        hashMap.put(class_1299.field_6084, class_3417.field_15190);
        hashMap.put(class_1299.field_6046, class_3417.field_14547);
        hashMap.put(class_1299.field_6123, class_3417.field_14647);
        hashMap.put(class_1299.field_6086, class_3417.field_14777);
        hashMap.put(class_1299.field_6116, class_3417.field_14854);
        hashMap.put(class_1299.field_6128, class_3417.field_15022);
        hashMap.put(class_1299.field_6090, class_3417.field_15113);
        hashMap.put(class_1299.field_6107, class_3417.field_14577);
        hashMap.put(class_1299.field_6118, class_3417.field_18813);
        hashMap.put(class_1299.field_21973, class_3417.field_24634);
        hashMap.put(class_1299.field_6071, class_3417.field_15185);
        hashMap.put(class_1299.field_6065, class_3417.field_15064);
        hashMap.put(class_1299.field_6102, class_3417.field_14963);
        hashMap.put(class_1299.field_6078, class_3417.field_14957);
        hashMap.put(class_1299.field_22281, class_3417.field_24635);
        hashMap.put(class_1299.field_25751, class_3417.field_25727);
        hashMap.put(class_1299.field_6105, class_3417.field_18815);
        hashMap.put(class_1299.field_6134, class_3417.field_18816);
        hashMap.put(class_1299.field_6109, class_3417.field_14768);
        hashMap.put(class_1299.field_6125, class_3417.field_14683);
        hashMap.put(class_1299.field_6137, class_3417.field_14587);
        hashMap.put(class_1299.field_6069, class_3417.field_15098);
        hashMap.put(class_1299.field_6079, class_3417.field_15190);
        hashMap.put(class_1299.field_6098, class_3417.field_14885);
        hashMap.put(class_1299.field_6059, class_3417.field_15032);
        hashMap.put(class_1299.field_6117, class_3417.field_14790);
        hashMap.put(class_1299.field_6145, class_3417.field_14796);
        hashMap.put(class_1299.field_6119, class_3417.field_14555);
        hashMap.put(class_1299.field_6076, class_3417.field_15073);
        hashMap.put(class_1299.field_23696, class_3417.field_24633);
        hashMap.put(class_1299.field_6051, class_3417.field_15220);
        hashMap.put(class_1299.field_6054, class_3417.field_14676);
    });
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    private float flapSpeed = 1.0f;
    private boolean songPlaying;
    private class_2338 songSource;

    public ParakeetEntity(class_1299<? extends ParakeetEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.setVariant(this.field_5974.nextInt(7));
        if (entityData == null) {
            entityData = new class_1296.class_4697(false);
        }
        return super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
    }

    public boolean method_6109() {
        return false;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1350((class_1321)this, 1.0, 5.0f, 1.0f, true));
        this.field_6201.method_6277(2, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1360((class_1471)this));
        this.field_6201.method_6277(3, (class_1352)new class_1348((class_1308)this, 1.0, 3.0f, 7.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, ParakeetEntity.class, 2.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1453.class, 2.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.6f;
    }

    public void method_6007() {
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 3.46) || !this.field_6002.method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        if (this.field_6002.field_9229.nextInt(400) == 0) {
            ParakeetEntity.imitateNearbyMob(this.field_6002, (class_1297)this);
        }
        super.method_6007();
        this.flapWings();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean getSongPlaying() {
        return this.songPlaying;
    }

    private void flapWings() {
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation = (float)((double)this.maxWingDeviation + (double)(!this.field_5952 && !this.method_5765() ? 4 : -1) * 0.3);
        this.maxWingDeviation = class_3532.method_15363((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.field_5952 && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }
        this.flapSpeed = (float)((double)this.flapSpeed * 0.9);
        class_243 vec3d = this.method_18798();
        if (!this.field_5952 && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
    }

    public static boolean imitateNearbyMob(class_1937 world, class_1297 parakeet) {
        if (parakeet.method_5805() && !parakeet.method_5701() && world.field_9229.nextInt(2) == 0) {
            class_1308 mobEntity;
            List list = world.method_8390(class_1308.class, parakeet.method_5829().method_1014(20.0), CAN_IMITATE);
            if (!list.isEmpty() && !(mobEntity = (class_1308)list.get(world.field_9229.nextInt(list.size()))).method_5701()) {
                class_3414 soundEvent = ParakeetEntity.getSound(mobEntity.method_5864());
                world.method_8465((class_1657)null, parakeet.method_23317(), parakeet.method_23318(), parakeet.method_23321(), soundEvent, parakeet.method_5634(), 0.7f, ParakeetEntity.getSoundPitch(world.field_9229));
                return true;
            }
            return false;
        }
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.field_6002.field_9236) {
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return class_1269.field_5812;
            }
            return !this.method_6481(itemStack) || this.method_6032() >= this.method_6063() && this.method_6181() ? class_1269.field_5811 : class_1269.field_5812;
        }
        if (this.method_6181() && this.method_6171((class_1309)player) && item.method_19263() && this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
            this.method_6475(player, itemStack);
            this.method_6025(item.method_19264().method_19230());
            return class_1269.field_21466;
        }
        if (!this.method_6181() && TAMING_INGREDIENTS.contains(itemStack.method_7909())) {
            if (!player.field_7503.field_7477) {
                itemStack.method_7934(1);
            }
            if (!this.method_5701()) {
                this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14960, this.method_5634(), 1.0f, 1.0f + (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f);
            }
            if (!this.field_6002.field_9236) {
                if (this.field_5974.nextInt(10) == 0) {
                    this.method_6170(player);
                    this.field_6002.method_8421((class_1297)this, (byte)7);
                } else {
                    this.field_6002.method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (itemStack.method_7909() == COOKIE) {
            if (!player.field_7503.field_7477) {
                itemStack.method_7934(1);
            }
            this.method_6092(new class_1293(class_1294.field_5899, 900));
            if (player.method_7337() || !this.method_5655()) {
                this.method_5643(class_1282.method_5532((class_1657)player), Float.MAX_VALUE);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (!this.isInAir() && this.method_6181() && this.method_6171((class_1309)player)) {
            if (!this.field_6002.field_9236) {
                this.method_24346(!this.method_24345());
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return BREEDING_ITEMS.method_8093(stack);
    }

    public static boolean canSpawn(class_1299<ParakeetEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        class_2680 blockState = world.method_8320(pos.method_10074());
        return (blockState.method_26164((class_3494)class_3481.field_15503) || blockState.method_27852(class_2246.field_10219) || blockState.method_26164((class_3494)class_3481.field_15475) || blockState.method_27852(class_2246.field_10124)) && world.method_22335(pos, 0) > 8;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public boolean method_6474(class_1429 other) {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
        return null;
    }

    public boolean method_6121(class_1297 target) {
        return target.method_5643(class_1282.method_5511((class_1309)this), 3.0f);
    }

    @Nullable
    public class_3414 method_5994() {
        return ParakeetEntity.getRandomSound(this.field_6002, this.field_6002.field_9229);
    }

    public static class_3414 getRandomSound(class_1937 world, Random random) {
        if (world.method_8407() != class_1267.field_5801 && random.nextInt(1000) == 0) {
            ArrayList list = Lists.newArrayList(MOB_SOUNDS.keySet());
            return ParakeetEntity.getSound((class_1299)list.get(random.nextInt(list.size())));
        }
        return class_3417.field_15132;
    }

    private static class_3414 getSound(class_1299<?> imitate) {
        return MOB_SOUNDS.getOrDefault(imitate, class_3417.field_15132);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15077;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15234;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14602, 0.15f, 1.0f);
    }

    protected float method_5801(float distance) {
        this.method_5783(class_3417.field_14925, 0.15f, 1.0f);
        return distance + this.maxWingDeviation / 2.0f;
    }

    protected boolean method_5776() {
        return true;
    }

    protected float method_6017() {
        return ParakeetEntity.getSoundPitch(this.field_5974);
    }

    public static float getSoundPitch(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public class_3419 method_5634() {
        return class_3419.field_15254;
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_6087(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            super.method_6087(entity);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.method_24346(false);
        return super.method_5643(source, amount);
    }

    public int getVariant() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(ATTR_VARIANT)), (int)0, (int)6);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(ATTR_VARIANT, (Object)variant);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTR_VARIANT, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10550("Variant"));
    }

    public boolean isInAir() {
        return !this.field_5952;
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }
}

