/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.block;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.common.tileentity.TileEntityMobFarm;
import cn.davidma.tinymobfarm.core.EnumMobFarm;
import cn.davidma.tinymobfarm.core.Reference;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockMobFarm
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private EnumMobFarm mobFarmData;

    public BlockMobFarm(EnumMobFarm mobFarmData) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)mobFarmData.getBaseBlock()));
        this.setRegistryName(Reference.getLocation(mobFarmData.getRegistryName()));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.mobFarmData = mobFarmData;
    }

    public MessagePassingQueue.Consumer<List<ITextComponent>> getTooltipBuilder() {
        return this.mobFarmData::addTooltip;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f().func_176734_d();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.setMobFarmData(this.mobFarmData);
            tileEntityMobFarm.updateRedstone();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntityMobFarm, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileEntity = world.func_175625_s(currentPos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.updateRedstone();
            tileEntityMobFarm.saveAndSync();
        }
        return state;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.updateRedstone();
            tileEntityMobFarm.saveAndSync();
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack lasso;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.func_201670_d() && tileEntity instanceof TileEntityMobFarm && !(lasso = ((TileEntityMobFarm)tileEntity).getLasso()).func_190926_b()) {
            ItemEntity drop = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.3, (double)pos.func_177952_p() + 0.5, lasso);
            world.func_217376_c((Entity)drop);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TinyMobFarm.tileEntityMobFarm.func_200968_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOUNDING_BOX;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }
}

