/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.item;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.core.Reference;
import cn.davidma.tinymobfarm.core.util.Config;
import cn.davidma.tinymobfarm.core.util.EntityHelper;
import cn.davidma.tinymobfarm.core.util.Msg;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemLasso
extends Item {
    public ItemLasso(Item.Properties properties) {
        super(properties.func_200916_a(TinyMobFarm.creativeTab).func_200915_b(Config.LASSO_DURABILITY));
        this.setRegistryName(Reference.getLocation("lasso"));
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (NBTHelper.hasMob(stack) || !target.func_70089_S() || !(target instanceof MobEntity)) {
            return ActionResultType.FAIL;
        }
        CompoundNBT nbt = NBTHelper.getBaseTag(stack);
        if (!target.func_184222_aU()) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.cannot_capture_boss");
            }
            return ActionResultType.SUCCESS;
        }
        if (EntityHelper.isMobBlacklisted(target)) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.blacklisted_mob");
            }
            return ActionResultType.SUCCESS;
        }
        if (!player.field_70170_p.func_201670_d()) {
            CompoundNBT mobData = target.serializeNBT();
            mobData.func_218657_a("Rotation", (INBT)NBTHelper.createNBTList(new INBT[]{DoubleNBT.func_229684_a_((double)0.0), DoubleNBT.func_229684_a_((double)0.0)}));
            nbt.func_218657_a("mobData", (INBT)mobData);
            ITextComponent name = target.func_200200_C_();
            if (name instanceof TranslationTextComponent) {
                nbt.func_74778_a("mobName", ((TranslationTextComponent)name).func_150268_i());
            } else {
                nbt.func_74778_a("mobName", name.func_150261_e());
            }
            nbt.func_74778_a("mobLootTableLocation", EntityHelper.getLootTableLocation(target));
            nbt.func_74780_a("mobHealth", (double)Math.round(target.func_110143_aJ() * 10.0f) / 10.0);
            nbt.func_74780_a("mobMaxHealth", (double)target.func_110138_aP());
            nbt.func_74757_a("mobHostile", target instanceof MonsterEntity);
            if (player.func_184812_l_()) {
                ItemStack newLasso = new ItemStack((IItemProvider)this);
                NBTHelper.setBaseTag(newLasso, nbt);
                player.func_191521_c(newLasso);
            }
            target.func_70106_y();
            player.field_71071_by.func_70296_d();
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a().func_177972_a(facing);
        World world = context.func_195991_k();
        if (!NBTHelper.hasMob(stack)) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195991_k().func_201670_d()) {
            CompoundNBT nbt = NBTHelper.getBaseTag(stack);
            CompoundNBT mobData = nbt.func_74775_l("mobData");
            DoubleNBT x = DoubleNBT.func_229684_a_((double)((double)pos.func_177958_n() + 0.5));
            DoubleNBT y = DoubleNBT.func_229684_a_((double)pos.func_177956_o());
            DoubleNBT z = DoubleNBT.func_229684_a_((double)((double)pos.func_177952_p() + 0.5));
            ListNBT mobPos = NBTHelper.createNBTList(new INBT[]{x, y, z});
            mobData.func_218657_a("Pos", (INBT)mobPos);
            Entity mob = EntityType.func_220335_a((CompoundNBT)mobData, (World)world, entity -> entity);
            if (mob != null) {
                world.func_217376_c(mob);
            }
            stack.func_196083_e("capturedMob");
            stack.func_222118_a(1, (LivingEntity)player, wutTheFak -> {});
            System.out.println(stack.func_77958_k());
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (NBTHelper.hasMob(stack)) {
            CompoundNBT nbt = NBTHelper.getBaseTag(stack);
            String name = nbt.func_74779_i("mobName");
            double health = nbt.func_74769_h("mobHealth");
            double maxHealth = nbt.func_74769_h("mobMaxHealth");
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.release_mob.key", new Object[0]));
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.mob_name.key", I18n.func_135052_a((String)name, (Object[])new Object[0])));
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.health.key", health, maxHealth));
            if (nbt.func_74767_n("mobHostile")) {
                tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.hostile.key", new Object[0]));
            }
        } else {
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.capture.key", new Object[0]));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.hasMob(stack);
    }
}

