/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.ClientEventHandler;
import com.github.iunius118.tolaserblade.client.renderer.entity.LaserTrapEntityRenderer;
import com.github.iunius118.tolaserblade.data.TLBAdvancementProvider;
import com.github.iunius118.tolaserblade.data.TLBItemModelProvider;
import com.github.iunius118.tolaserblade.data.TLBItemTagsProvider;
import com.github.iunius118.tolaserblade.data.TLBLanguageProvider;
import com.github.iunius118.tolaserblade.data.TLBRecipeProvider;
import com.github.iunius118.tolaserblade.data.TLBSoundProvider;
import com.github.iunius118.tolaserblade.enchantment.LightElementEnchantment;
import com.github.iunius118.tolaserblade.entity.LaserTrapEntity;
import com.github.iunius118.tolaserblade.entity.ModEntities;
import com.github.iunius118.tolaserblade.item.DXLaserBladeItem;
import com.github.iunius118.tolaserblade.item.ItemEventHandler;
import com.github.iunius118.tolaserblade.item.LBBatteryItem;
import com.github.iunius118.tolaserblade.item.LBBlueprintItem;
import com.github.iunius118.tolaserblade.item.LBBrokenItem;
import com.github.iunius118.tolaserblade.item.LBCasingItem;
import com.github.iunius118.tolaserblade.item.LBDisassembledItem;
import com.github.iunius118.tolaserblade.item.LBEmitterItem;
import com.github.iunius118.tolaserblade.item.LBMediumItem;
import com.github.iunius118.tolaserblade.item.LaserBladeItem;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.network.NetworkHandler;
import com.github.iunius118.tolaserblade.network.ServerConfigMessage;
import java.util.HashMap;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tolaserblade")
@Mod.EventBusSubscriber
public class ToLaserBlade {
    public static final String MOD_ID = "tolaserblade";
    public static final String MOD_NAME = "ToLaserBlade";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean hasShownUpdate = false;
    public static final NetworkHandler NETWORK_HANDLER = new NetworkHandler();

    public ToLaserBlade() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::initClient);
        modEventBus.register(ToLaserBladeConfig.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ToLaserBladeConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ToLaserBladeConfig.clientSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEventHandler());
        if (FMLLoader.getDist().isClient()) {
            modEventBus.register((Object)new ClientEventHandler());
        }
    }

    private void initClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.LASER_TRAP, LaserTrapEntityRenderer::new);
    }

    @SubscribeEvent
    public static void remapItems(RegistryEvent.MissingMappings<Item> mappings) {
        HashMap<ResourceLocation, Object> remappingItemMap = new HashMap<ResourceLocation, Object>();
        remappingItemMap.put(new ResourceLocation(MOD_ID, "tolaserblade.laser_blade"), ModItems.LASER_BLADE);
        remappingItemMap.put(new ResourceLocation(MOD_ID, "lasar_blade"), (Object)ModItems.DX_LASER_BLADE);
        remappingItemMap.put(new ResourceLocation(MOD_ID, "laser_blade_core"), ModItems.LB_BROKEN);
        mappings.getAllMappings().stream().filter(mapping -> mapping.key.func_110624_b().equals(MOD_ID) && remappingItemMap.containsKey(mapping.key)).forEach(mapping -> mapping.remap((IForgeRegistryEntry)remappingItemMap.get(mapping.key)));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ToLaserBladeConfig.ServerConfig serverConfig = new ToLaserBladeConfig.ServerConfig();
        NETWORK_HANDLER.getConfigChannel().sendTo((Object)new ServerConfigMessage(serverConfig), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public void onEntityJoiningInWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity && ((Boolean)ToLaserBladeConfig.CLIENT.showUpdateMessage.get()).booleanValue() && !hasShownUpdate) {
            ClientEventHandler.checkUpdate();
            hasShownUpdate = true;
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new DXLaserBladeItem().setRegistryName("dx_laser_blade"), (Item)new LaserBladeItem(false).setRegistryName("laser_blade"), (Item)new LaserBladeItem(true).setRegistryName("laser_blade_fp"), (Item)new LBBrokenItem(false).setRegistryName("lb_broken"), (Item)new LBBrokenItem(true).setRegistryName("lb_broken_fp"), (Item)new LBBlueprintItem().setRegistryName("lb_blueprint"), (Item)new LBDisassembledItem(false).setRegistryName("lb_disassembled"), (Item)new LBDisassembledItem(true).setRegistryName("lb_disassembled_fp"), (Item)new LBBatteryItem().setRegistryName("lb_battery"), (Item)new LBMediumItem().setRegistryName("lb_medium"), (Item)new LBEmitterItem().setRegistryName("lb_emitter"), (Item)new LBCasingItem(false).setRegistryName("lb_casing"), (Item)new LBCasingItem(true).setRegistryName("lb_casing_fp")});
        }

        @SubscribeEvent
        public static void onEnchantmentRegistry(RegistryEvent.Register<Enchantment> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new LightElementEnchantment().setRegistryName(LightElementEnchantment.ID)});
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            EntityType laserTrap = EntityType.Builder.func_220322_a(LaserTrapEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_220320_c().setTrackingRange(64).setUpdateInterval(4).setShouldReceiveVelocityUpdates(false).func_206830_a(LaserTrapEntity.ID.toString());
            LOGGER.info("This warning from the data fixer is not an issue for modded entities");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)laserTrap.setRegistryName(LaserTrapEntity.ID)});
        }

        @SubscribeEvent
        public static void onSoundEventRegistry(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(new ResourceLocation(ToLaserBlade.MOD_ID, "item.dx_laser_blade.swing")).setRegistryName("item_dx_laser_blade_swing")});
        }

        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            ForgeBlockTagsProvider blockTags = new ForgeBlockTagsProvider(gen, existingFileHelper);
            if (event.includeServer()) {
                gen.func_200390_a((IDataProvider)new TLBRecipeProvider(gen));
                gen.func_200390_a((IDataProvider)new TLBItemTagsProvider(gen, (BlockTagsProvider)blockTags, existingFileHelper));
                gen.func_200390_a((IDataProvider)new TLBAdvancementProvider(gen));
            }
            if (event.includeClient()) {
                gen.func_200390_a((IDataProvider)new TLBItemModelProvider(gen, existingFileHelper));
                TLBLanguageProvider.addProviders(gen);
                gen.func_200390_a((IDataProvider)new TLBSoundProvider(gen));
            }
        }
    }
}

