/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.network.ServerConfigMessage;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ToLaserBladeConfig {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.COMMON && ServerLifecycleHooks.getCurrentServer() != null) {
            ServerConfig serverConfig = new ServerConfig();
            ToLaserBlade.NETWORK_HANDLER.getConfigChannel().send(PacketDistributor.ALL.noArg(), (Object)new ServerConfigMessage(serverConfig));
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer = () -> ((ForgeConfigSpec.BooleanValue)ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBlade).get();
        ToLaserBladeConfig.COMMON.laserBladeEfficiencyInServer = () -> ((ForgeConfigSpec.IntValue)ToLaserBladeConfig.COMMON.laserBladeEfficiency).get();
        ToLaserBladeConfig.COMMON.maxAttackDamageUpgradeCountInServer = () -> ((ForgeConfigSpec.IntValue)ToLaserBladeConfig.COMMON.maxAttackDamageUpgradeCount).get();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class ServerConfig {
        public boolean isEnabledBlockingWithLaserBladeInServer;
        public int laserBladeEfficiencyInServer;
        public int maxAttackDamageUpgradeCountInServer;

        public ServerConfig() {
            this.isEnabledBlockingWithLaserBladeInServer = (Boolean)ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBlade.get();
            this.laserBladeEfficiencyInServer = (Integer)ToLaserBladeConfig.COMMON.laserBladeEfficiency.get();
            this.maxAttackDamageUpgradeCountInServer = (Integer)ToLaserBladeConfig.COMMON.maxAttackDamageUpgradeCount.get();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showUpdateMessage;
        public final ForgeConfigSpec.BooleanValue useFixedVertexBuffer;
        public final ForgeConfigSpec.BooleanValue useInternalModel;
        public final ForgeConfigSpec.IntValue internalModelType;
        public final ForgeConfigSpec.IntValue externalModelType;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("ToLaserBlade's client side settings.").push("client");
            this.showUpdateMessage = builder.comment("Enable to show update message.\nDefault: true").translation("tolaserblade.configgui.client.showUpdateMessage").define("showUpdateMessage", true);
            this.useFixedVertexBuffer = builder.comment("Add mod's vertex buffers to Minecraft's fixed buffer list.\nNeed to restart client after changing this.\nDefault: true").translation("tolaserblade.configgui.client.useFixedVertexBuffer").define("useFixedVertexBuffer", true);
            this.useInternalModel = builder.comment("Using internal model for rendering Laser Blade. Set to false to use the model that loaded from resource packs.\nNeed to reload resource packs after changing this.\nDefault: true").translation("tolaserblade.configgui.client.useInternalModel").define("useInternalModel", true);
            this.internalModelType = builder.comment("Select type of internal model to use for rendering Laser Blade (0: original model, 1: another model). This setting is valid when useInternalModel is true.\nNeed to reload resource packs after changing this.\nDefault: -1").translation("tolaserblade.configgui.client.internalModelType").defineInRange("internalModelType", -1, -1, Integer.MAX_VALUE);
            this.externalModelType = builder.comment("Select type of external model to use for rendering Laser Blade (0: generated model, 1: OBJ model). This setting is valid when useInternalModel is false.\nNeed to reload resource packs after changing this.\nDefault: 0").translation("tolaserblade.configgui.client.externalModelType").defineInRange("externalModelType", 0, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue isEnabledBlockingWithLaserBlade;
        public Supplier<Boolean> isEnabledBlockingWithLaserBladeInServer;
        public final ForgeConfigSpec.IntValue laserBladeEfficiency;
        public Supplier<Integer> laserBladeEfficiencyInServer;
        public final ForgeConfigSpec.IntValue maxAttackDamageUpgradeCount;
        public Supplier<Integer> maxAttackDamageUpgradeCountInServer;
        public final ForgeConfigSpec.BooleanValue isEnabledLaserTrap;
        public final ForgeConfigSpec.BooleanValue canLaserTrapAttackPlayer;
        public final ForgeConfigSpec.BooleanValue canLaserTrapHeatUpFurnace;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("ToLaserBlade's common settings.").push("common");
            this.isEnabledBlockingWithLaserBlade = builder.comment("Enable blocking with Laser Blade.\nDefault: false").translation("tolaserblade.configgui.common.enableBlockingWithLaserBlade").define("enableBlockingWithLaserBlade", false);
            this.laserBladeEfficiency = builder.comment("An integer value (0-128) that is a factor of mining speed of Laser Blade.\nDefault: 12").translation("tolaserblade.configgui.common.laserBladeEfficiencyInServer").defineInRange("laserBladeEfficiencyInServer", 12, 0, 128);
            this.maxAttackDamageUpgradeCount = builder.comment("An integer value (0-39) that is maximum count of attack damage upgrade of Laser Blade.\nNote:\n  Making the advancement [It's Over 9] requires 3 or more.\n  Similarly, [Beyond the Limit] requires 8 or more.\nDefault: 8").translation("tolaserblade.configgui.common.maxAttackDamageUpgradeCount").defineInRange("maxAttackDamageUpgradeCount", 8, 0, 39);
            this.isEnabledLaserTrap = builder.comment("Enable to attack with Laser Blade in Dispenser when the dispenser is activated.\nDefault: true").translation("tolaserblade.configgui.common.enableLaserTrap").define("enableLaserTrap", true);
            this.canLaserTrapAttackPlayer = builder.comment("A boolean value represents whether laser trap can attack player or not. This setting is valid when enableLaserTrap is true.\nDefault: false").translation("tolaserblade.configgui.common.canLaserTrapAttackPlayer").define("canLaserTrapAttackPlayer", false);
            this.canLaserTrapHeatUpFurnace = builder.comment("A boolean value represents whether laser trap with fireproof Laser Blade can heat up furnace or not. This setting is valid when enableLaserTrap is true.\nDefault: true").translation("tolaserblade.configgui.common.canLaserTrapHeatUpFurnace").define("canLaserTrapHeatUpFurnace", true);
            builder.pop();
        }
    }
}

