/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item.crafting;

import com.github.iunius118.tolaserblade.enchantment.ModEnchantments;
import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.upgrade.LaserBladeUpgrade;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class LaserBladeCrafting {
    private final ItemStack result;
    private final LaserBladeItemBase resultItem;
    private boolean isCraftTweakerRecipe = false;
    private int bladeGripColor = LaserBladeItemBase.DEFAULT_COLOR_GRIP;
    private int bladeInnerColor = LaserBladeItemBase.DEFAULT_COLOR_INNER;
    private int bladeOuterColor = LaserBladeItemBase.DEFAULT_COLOR_OUTER;
    private boolean isBladeInnerSubColor = false;
    private boolean isBladeOuterSubColor = false;
    private float attackDamage = 0.0f;
    private float attackSpeed = 0.0f;
    private final Map<Enchantment, Integer> enchantments = Maps.newLinkedHashMap();
    private ITextComponent name;

    public LaserBladeCrafting(PlayerEvent.ItemCraftedEvent event, LaserBladeItemBase resultItemIn) {
        this.result = event.getCrafting();
        this.resultItem = resultItemIn;
        if (this.result.func_77942_o()) {
            CompoundNBT tag = this.result.func_77978_p();
            this.isCraftTweakerRecipe = tag.func_74767_n("ct");
            tag.func_82580_o("ct");
            if (this.isCraftTweakerRecipe) {
                return;
            }
        }
        IInventory inventory = event.getInventory();
        if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.MEDIUM)) {
            this.enchantments.put(ModEnchantments.LIGHT_ELEMENT, 1);
            this.modifyColorsByBiome(event.getPlayer());
        } else if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.EMITTER)) {
            this.modifyColorsByBiome(event.getPlayer());
        }
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack ingredient = inventory.func_70301_a(i);
                if (ingredient.func_190926_b()) continue;
                Item item = ingredient.func_77973_b();
                if (item instanceof LaserBladeItemBase) {
                    this.addEnchantments(ingredient);
                    this.setColors(ingredient);
                    this.setAttackDamage(ingredient);
                    this.setAttackSpeed(ingredient);
                    this.setName(ingredient);
                    continue;
                }
                if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.BATTERY) && Tags.Items.DUSTS_REDSTONE.func_230235_a_((Object)item)) {
                    this.addEnchantment(Enchantments.field_185305_q, 1);
                    continue;
                }
                if (!this.resultItem.canUpgrade(LaserBladeUpgrade.Type.MEDIUM) || !Tags.Items.DUSTS_GLOWSTONE.func_230235_a_((Object)item)) continue;
                this.addEnchantment(ModEnchantments.LIGHT_ELEMENT, 2);
            }
        }
    }

    public ItemStack getResult() {
        if (this.isCraftTweakerRecipe) {
            return this.result;
        }
        CompoundNBT nbt = this.result.func_196082_o();
        if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.BATTERY)) {
            nbt.func_74776_a("SPD", this.attackSpeed);
        }
        if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.MEDIUM)) {
            nbt.func_74776_a("ATK", this.attackDamage);
            nbt.func_74768_a("colorH", this.bladeOuterColor);
            nbt.func_74757_a("isSubH", this.isBladeOuterSubColor);
        }
        if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.EMITTER)) {
            nbt.func_74768_a("colorC", this.bladeInnerColor);
            nbt.func_74757_a("isSubC", this.isBladeInnerSubColor);
        }
        if (this.resultItem.canUpgrade(LaserBladeUpgrade.Type.CASING)) {
            nbt.func_74768_a("colorG", this.bladeGripColor);
            if (this.name != null) {
                this.result.func_200302_a(this.name);
            }
        }
        EnchantmentHelper.func_82782_a(this.enchantments, (ItemStack)this.result);
        return this.result;
    }

    private void addEnchantment(Enchantment enchantment, int level) {
        if (this.enchantments.containsKey(enchantment)) {
            if (this.enchantments.get(enchantment) < level) {
                this.enchantments.put(enchantment, level);
            }
        } else {
            this.enchantments.put(enchantment, level);
        }
    }

    private void addEnchantments(ItemStack ingredient) {
        Map ingredientEnchantments = EnchantmentHelper.func_82781_a((ItemStack)ingredient);
        ingredientEnchantments.forEach((e, lvl) -> {
            if (this.enchantments.containsKey(e)) {
                if (this.enchantments.get(e) < lvl) {
                    this.enchantments.put((Enchantment)e, (Integer)lvl);
                }
            } else {
                this.enchantments.put((Enchantment)e, (Integer)lvl);
            }
        });
    }

    private void setAttackDamage(ItemStack ingredient) {
        if (ingredient.func_77942_o() && ingredient.func_77978_p().func_150297_b("ATK", 5)) {
            this.attackDamage = Math.max(this.attackDamage, ModItems.LB_MEDIUM.getLaserBladeATK(ingredient));
        }
    }

    private void setAttackSpeed(ItemStack ingredient) {
        if (ingredient.func_77942_o() && ingredient.func_77978_p().func_150297_b("SPD", 5)) {
            this.attackSpeed = Math.max(this.attackSpeed, ModItems.LB_BATTERY.getLaserBladeSPD(ingredient));
        }
    }

    private void setColors(ItemStack ingredient) {
        CompoundNBT nbt = ingredient.func_77978_p();
        if (nbt == null) {
            return;
        }
        if (nbt.func_150297_b("colorG", 3)) {
            this.bladeGripColor = nbt.func_74762_e("colorG");
        }
        if (nbt.func_150297_b("colorC", 3)) {
            this.bladeInnerColor = nbt.func_74762_e("colorC");
        }
        if (nbt.func_150297_b("colorH", 3)) {
            this.bladeOuterColor = nbt.func_74762_e("colorH");
        }
        if (nbt.func_150297_b("isSubC", 1)) {
            this.isBladeInnerSubColor = nbt.func_74767_n("isSubC");
        }
        if (nbt.func_150297_b("isSubH", 1)) {
            this.isBladeOuterSubColor = nbt.func_74767_n("isSubH");
        }
    }

    private void setName(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        if (item instanceof LaserBladeItemBase && ((LaserBladeItemBase)item).canUpgrade(LaserBladeUpgrade.Type.CASING) && ingredient.func_82837_s()) {
            this.name = ingredient.func_200301_q();
        }
    }

    private void modifyColorsByBiome(PlayerEntity player) {
        World world = player.field_70170_p;
        Biome biome = world.func_226691_t_(player.func_233580_cy_());
        if (biome.func_201856_r() == Biome.Category.NETHER) {
            this.isBladeInnerSubColor = true;
        } else if (biome.func_201856_r() == Biome.Category.THEEND) {
            this.isBladeOuterSubColor = true;
        } else {
            float temp = biome.func_242445_k();
            this.bladeOuterColor = temp > 1.5f ? LaserBladeItemBase.LBColor.TEMP_DESERT.getBladeColor() : (temp > 1.0f ? LaserBladeItemBase.LBColor.TEMP_SAVANNA.getBladeColor() : (temp > 0.8f ? LaserBladeItemBase.LBColor.TEMP_JUNGLE.getBladeColor() : (temp >= 0.5f ? LaserBladeItemBase.LBColor.RED.getBladeColor() : (temp >= 0.2f ? LaserBladeItemBase.LBColor.TEMP_TAIGA.getBladeColor() : (temp >= -0.25f ? LaserBladeItemBase.LBColor.TEMP_ICE_PLAIN.getBladeColor() : LaserBladeItemBase.LBColor.TEMP_SNOWY_TAIGA.getBladeColor())))));
        }
    }
}

