/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item.upgrade;

import com.github.iunius118.tolaserblade.enchantment.ModEnchantments;
import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class LaserBladeUpgrade {
    public static void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack right = event.getIngredientInput();
        ItemStack output = event.getItemResult();
        String name = output.func_200301_q().getString();
        if ("GIFT".equals(name) || "\u304a\u305f\u304b\u3089".equals(name)) {
            boolean isLightElementLessThan5;
            boolean hasUpgraded = false;
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)output);
            int lightElementLevel = enchantments.getOrDefault(ModEnchantments.LIGHT_ELEMENT, 0);
            int smiteLevel = enchantments.getOrDefault(Enchantments.field_185303_l, 0);
            boolean bl = isLightElementLessThan5 = lightElementLevel < 5;
            if (ModItems.LASER_BLADE.getLaserBladeATK(output) < 3.0f) {
                ModItems.LASER_BLADE.setLaserBladeATK(output, 3.0f);
                hasUpgraded = true;
            }
            if (lightElementLevel < 5) {
                lightElementLevel = 5;
                hasUpgraded = true;
            }
            if (lightElementLevel < ModEnchantments.LIGHT_ELEMENT.func_77325_b() && lightElementLevel < smiteLevel) {
                lightElementLevel = Math.min(smiteLevel, ModEnchantments.LIGHT_ELEMENT.func_77325_b());
                hasUpgraded = true;
            }
            enchantments.put(ModEnchantments.LIGHT_ELEMENT, lightElementLevel);
            LinkedHashMap newEnchantments = Maps.newLinkedHashMap();
            enchantments.forEach((e, lvl) -> {
                if (e.func_191560_c(ModEnchantments.LIGHT_ELEMENT) || e.equals(ModEnchantments.LIGHT_ELEMENT)) {
                    newEnchantments.put(e, lvl);
                }
            });
            EnchantmentHelper.func_82782_a((Map)newEnchantments, (ItemStack)output);
            if (hasUpgraded) {
                output.func_135074_t();
                ModItems.LASER_BLADE.setGripColor(output, LaserBladeItemBase.LBColor.BROWN.getGripColor());
                ModItems.LASER_BLADE.setBladeInnerColor(output, LaserBladeItemBase.LBColor.WHITE.getBladeColor());
                ModItems.LASER_BLADE.setBladeOuterColor(output, LaserBladeItemBase.LBColor.LIME.getBladeColor());
                ModItems.LASER_BLADE.setBladeInnerSubColorFlag(output, false);
                ModItems.LASER_BLADE.setBladeOuterSubColorFlag(output, false);
            }
        }
    }

    public static void onAnvilUpdate(AnvilUpdateEvent event, LaserBladeItemBase laserBlade) {
        ItemStack output;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item rightItem = right.func_77973_b();
        if (rightItem instanceof LaserBladeItemBase) {
            event.setCanceled(true);
        }
        List<Triple<ITag.INamedTag<Item>, Type, Function<ItemStack, UpgradeResult>>> tags = ModItemTags.getTags();
        for (Triple<ITag.INamedTag<Item>, Type, Function<ItemStack, UpgradeResult>> tag : tags) {
            if (!((ITag.INamedTag)tag.getLeft()).func_230235_a_((Object)rightItem) || !laserBlade.canUpgrade((Type)((Object)tag.getMiddle()))) continue;
            UpgradeResult result = (UpgradeResult)((Function)tag.getRight()).apply(left.func_77946_l());
            ItemStack output2 = result.getItemStack();
            int cost = result.getCost();
            if ((cost += LaserBladeUpgrade.changeDisplayName(output2, event.getName())) > 0) {
                event.setCost(cost);
                event.setMaterialCost(1);
                event.setOutput(output2);
            }
            return;
        }
        if (rightItem instanceof BlockItem) {
            int oldColor;
            int newColor;
            Block block = ((BlockItem)rightItem).func_179223_d();
            output = ItemStack.field_190927_a;
            int cost = 0;
            if (block instanceof StainedGlassBlock && laserBlade.canUpgrade(Type.MEDIUM)) {
                int oldColor2;
                int newColor2 = ModItems.LB_MEDIUM.getBladeColorFromTintIndex(((StainedGlassBlock)block).func_196457_d().func_196059_a(), true);
                if (newColor2 != (oldColor2 = ((Integer)ModItems.LB_MEDIUM.getBladeOuterColor(left).getLeft()).intValue())) {
                    output = left.func_77946_l();
                    ModItems.LB_MEDIUM.setBladeOuterColor(output, newColor2);
                    cost = 1;
                }
            } else if (block instanceof StainedGlassPaneBlock && laserBlade.canUpgrade(Type.EMITTER)) {
                int oldColor3;
                int newColor3 = ModItems.LB_EMITTER.getBladeColorFromTintIndex(((StainedGlassPaneBlock)block).func_196457_d().func_196059_a(), false);
                if (newColor3 != (oldColor3 = ((Integer)ModItems.LB_EMITTER.getBladeInnerColor(left).getLeft()).intValue())) {
                    output = left.func_77946_l();
                    ModItems.LB_MEDIUM.setBladeInnerColor(output, newColor3);
                    cost = 1;
                }
            } else if (block instanceof CarpetBlock && laserBlade.canUpgrade(Type.CASING) && (newColor = ModItems.LB_CASING.getGripColorFromTintIndex(((CarpetBlock)block).func_196547_d().func_196059_a())) != (oldColor = ModItems.LB_CASING.getGripColor(left))) {
                output = left.func_77946_l();
                ModItems.LB_CASING.setGripColor(output, newColor);
                cost = 1;
            }
            if ((cost += LaserBladeUpgrade.changeDisplayName(output, event.getName())) > 0) {
                event.setCost(cost);
                event.setMaterialCost(1);
                event.setOutput(output);
            }
        } else if (rightItem == Items.field_151121_aF && right.func_82837_s()) {
            String code = right.func_200301_q().getString();
            output = ItemStack.field_190927_a;
            int cost = 0;
            if ("FATE".equals(code) && laserBlade.canUpgrade(Type.MEDIUM)) {
                boolean flag = (Boolean)ModItems.LASER_BLADE.getBladeOuterColor(output = left.func_77946_l()).getRight();
                ModItems.LASER_BLADE.setBladeOuterSubColorFlag(output, !flag);
                cost = 1;
            } else if ("OGRE".equals(code) && laserBlade.canUpgrade(Type.EMITTER)) {
                boolean flag = (Boolean)ModItems.LASER_BLADE.getBladeInnerColor(output = left.func_77946_l()).getRight();
                ModItems.LASER_BLADE.setBladeInnerSubColorFlag(output, !flag);
                cost = 1;
            }
            if ((cost += LaserBladeUpgrade.changeDisplayName(output, event.getName())) > 0) {
                event.setCost(cost);
                event.setMaterialCost(1);
                event.setOutput(output);
            }
        }
    }

    private static int changeDisplayName(ItemStack stack, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            if (stack.func_82837_s()) {
                stack.func_135074_t();
                return 1;
            }
        } else if (!name.equals(stack.func_200301_q().getString())) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(name));
            return 1;
        }
        return 0;
    }

    public static enum Type {
        BATTERY,
        MEDIUM,
        EMITTER,
        CASING,
        REPAIR,
        OTHER;

    }
}

