/*
 * Decompiled with CFR 0.152.
 */
package net.Segovo.TrajectoryFabric;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import me.shedaniel.cloth.api.client.events.v0.ClothClientHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL11;

public class TrajectoryFabric
implements ClientModInitializer {
    final boolean smoothLines = true;
    static File configFile = new File(FabricLoader.getInstance().getConfigDirectory() + "/trajectoryconfig.json");
    static FileConfig config = FileConfig.of((File)configFile);
    static double angleToHit = 0.0;

    public static FileConfig getConfigRef() {
        return config;
    }

    public static void remoteLoadConfig() {
        config.load();
    }

    public boolean checkConfig() {
        config.load();
        Optional version = config.getOptional("version");
        if (!version.isPresent()) {
            System.out.println("No Config!");
            config.set("version", (Object)1);
            config.set("lineColorR", (Object)255);
            config.set("lineColorG", (Object)255);
            config.set("lineColorB", (Object)255);
            config.set("lineColorA", (Object)100);
            config.save();
            config.load();
            return false;
        }
        System.out.println("Config Found!");
        return true;
    }

    public static void setVelocity() {
    }

    public static void renderBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x1, (double)y2, (double)z1);
        GL11.glVertex3d((double)x2, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z1);
        GL11.glVertex3d((double)x1, (double)y1, (double)z2);
        GL11.glVertex3d((double)x1, (double)y2, (double)z2);
        GL11.glVertex3d((double)x2, (double)y1, (double)z2);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y1, (double)z1);
        GL11.glVertex3d((double)x1, (double)y2, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z1);
        GL11.glVertex3d((double)x1, (double)y1, (double)z2);
        GL11.glVertex3d((double)x2, (double)y1, (double)z2);
        GL11.glVertex3d((double)x1, (double)y2, (double)z2);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x1, (double)y1, (double)z2);
        GL11.glVertex3d((double)x2, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y1, (double)z2);
        GL11.glVertex3d((double)x1, (double)y2, (double)z1);
        GL11.glVertex3d((double)x1, (double)y2, (double)z2);
        GL11.glVertex3d((double)x2, (double)y2, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
    }

    public static void renderCurve(class_4184 camera, class_1937 world, class_2338 pos, float pitch, float yaw, double eye, class_1657 player, int[] color) {
        double d0 = camera.method_19326().field_1352;
        double d1 = camera.method_19326().field_1351 - 0.005;
        double d2 = camera.method_19326().field_1350;
        int pX = pos.method_10263();
        int pY = pos.method_10264();
        int pZ = pos.method_10260();
        double accurateX = player.method_23317();
        double accurateY = player.method_23318();
        double accurateZ = player.method_23321();
        RenderSystem.color4f((float)((float)color[0] / 255.0f), (float)((float)color[1] / 255.0f), (float)((float)color[2] / 255.0f), (float)((float)color[3] / 100.0f));
        float speed = 1.5f;
        float ngravity = 0.03f;
        float drag = 0.99f;
        float entityVelX = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float entityVelY = -class_3532.method_15374((float)(pitch * ((float)Math.PI / 180)));
        float entityVelZ = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        class_243 vec3d = new class_243((double)entityVelX, (double)entityVelY, (double)entityVelZ).method_1029().method_1021((double)speed);
        class_243 playerVelocity = player.method_18798();
        vec3d = vec3d.method_1031(playerVelocity.field_1352, player.method_24828() ? 0.0 : playerVelocity.field_1351, playerVelocity.field_1350);
        class_243 entityVelocity = new class_243(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
        class_243 entityPosition = new class_243(0.0, 1.5, 0.0);
        double offsetX = 0.0 * Math.cos(Math.toRadians((yaw + 90.0f) * -1.0f)) + 1.0 * Math.sin(Math.toRadians((yaw + 90.0f) * -1.0f));
        double offsetZ = 0.0 * Math.sin(Math.toRadians((yaw + 90.0f) * -1.0f)) + 1.0 * Math.cos(Math.toRadians((yaw + 90.0f) * -1.0f));
        double prevX = 0.0;
        double prevZ = 0.0;
        class_1680 tempEntity = new class_1680(world, (class_1309)player);
        for (int i = 0; i < 100; ++i) {
            class_3965 hitResult = world.method_17742(new class_3959(new class_243(accurateX + entityPosition.field_1352, accurateY + entityPosition.field_1351, accurateZ + entityPosition.field_1350), new class_243(accurateX + entityPosition.field_1352, accurateY + entityPosition.field_1351, accurateZ + entityPosition.field_1350).method_1019(entityVelocity), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)tempEntity));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                double hitDistance = hitResult.method_17784().method_1022(player.method_19538());
                double boxSize = hitDistance > 20.0 ? hitDistance / 40.0 : 0.5;
                double defaultBoxSize = 0.5;
                TrajectoryFabric.renderBox(hitResult.method_17784().field_1352 - defaultBoxSize - d0, hitResult.method_17784().field_1351 - defaultBoxSize - d1, hitResult.method_17784().field_1350 - defaultBoxSize - d2, hitResult.method_17784().field_1352 + defaultBoxSize - d0, hitResult.method_17784().field_1351 + defaultBoxSize - d1, hitResult.method_17784().field_1350 + defaultBoxSize - d2);
                TrajectoryFabric.renderBox(hitResult.method_17784().field_1352 - boxSize - d0, hitResult.method_17784().field_1351 - boxSize - d1, hitResult.method_17784().field_1350 - boxSize - d2, hitResult.method_17784().field_1352 + boxSize - d0, hitResult.method_17784().field_1351 + boxSize - d1, hitResult.method_17784().field_1350 + boxSize - d2);
                angleToHit = Math.acos(1.0 / hitDistance);
                break;
            }
            GL11.glVertex3d((double)(prevX + offsetX + (accurateX - d0)), (double)(entityPosition.field_1351 + (accurateY - d1)), (double)(prevZ + offsetZ + (accurateZ - d2)));
            entityPosition = entityPosition.method_1019(entityVelocity);
            entityVelocity = entityVelocity.method_1021((double)drag);
            entityVelocity = new class_243(entityVelocity.field_1352, entityVelocity.field_1351 - (double)ngravity, entityVelocity.field_1350);
            double newX = entityPosition.field_1352 * Math.cos(angleToHit - 1.5708) - entityPosition.field_1350 * Math.sin(angleToHit - 1.5708);
            double newZ = entityPosition.field_1352 * Math.sin(angleToHit - 1.5708) + entityPosition.field_1350 * Math.cos(angleToHit - 1.5708);
            GL11.glVertex3d((double)(newX + offsetX + (accurateX - d0)), (double)(entityPosition.field_1351 + (accurateY - d1)), (double)(newZ + offsetZ + (accurateZ - d2)));
            prevX = newX;
            prevZ = newZ;
        }
    }

    public void onInitializeClient() {
        System.out.println(FabricLoader.getInstance().getConfigDirectory());
        this.checkConfig();
        config.load();
        HashSet<class_1792> items = new HashSet<class_1792>();
        items.add(class_1802.field_8634.method_8389());
        items.add(class_1802.field_8543.method_8389());
        items.add(class_1802.field_8803.method_8389());
        class_310 client = class_310.method_1551();
        ClothClientHooks.DEBUG_RENDER_PRE.register(() -> {
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)1);
            class_746 playerEntity = client.field_1724;
            class_638 world = client.field_1687;
            class_2338 blockPos = new class_2338(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
            class_4184 camera = client.field_1773.method_19418();
            float pitch = playerEntity.field_5965;
            float yaw = playerEntity.field_6031;
            double eye = playerEntity.method_23320();
            class_1799 itemStack = playerEntity.method_6047();
            if (items.contains(itemStack.method_7909())) {
                int[] color = new int[]{(Integer)config.get("lineColorR"), (Integer)config.get("lineColorG"), (Integer)config.get("lineColorB"), (Integer)config.get("lineColorA")};
                TrajectoryFabric.renderCurve(camera, (class_1937)world, blockPos, pitch, yaw, eye, (class_1657)playerEntity, color);
            }
            GL11.glEnd();
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
            GL11.glDisable((int)2848);
        });
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {});
        System.out.println("Hello from TrajectoryFabric!");
    }
}

