/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    protected static final VoxelShape SLEEPING_BAG = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SleepingBagBlock(AbstractBlock.Properties properties) {
        super(DyeColor.RED, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.FALSE));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b(PART) != BedPart.HEAD && !(state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!SleepingBagBlock.func_235330_a_((World)worldIn)) {
            worldIn.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (worldIn.func_180495_p(blockpos).func_203425_a((Block)this)) {
                worldIn.func_217377_a(blockpos, false);
            }
            worldIn.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)OCCUPIED)).booleanValue()) {
            if (!this.wakeVillagers(worldIn, pos)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        BlockPos finalPos = pos;
        player.func_213819_a(pos).ifLeft(result -> {
            if (result != null) {
                player.func_146105_b(result.func_221259_a(), true);
                if (result == PlayerEntity.SleepResult.NOT_POSSIBLE_NOW) {
                    ((ServerPlayerEntity)player).func_242111_a(((ServerPlayerEntity)player).func_241141_L_(), finalPos, 1.0f, true, false);
                }
            }
        });
        return ActionResultType.SUCCESS;
    }

    private boolean wakeVillagers(World world, BlockPos pos) {
        List list = world.func_175647_a(VillagerEntity.class, new AxisAlignedBB(pos), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.updateMotion(entityIn);
        }
    }

    private void updateMotion(Entity entity) {
        Vector3d vec3d = entity.func_213322_ci();
        if (vec3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * (double)0.66f * d0, vec3d.field_72449_c);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == SleepingBagBlock.getDirectionToOther((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((Property)field_185512_D))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((Property)OCCUPIED, facingState.func_177229_b((Property)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos backpackPos;
        boolean isFoot = state.func_177229_b(PART) == BedPart.FOOT;
        BlockPos blockPos = backpackPos = isFoot ? pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d()) : pos.func_177967_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d(), 2);
        if (worldIn.func_180495_p(backpackPos).func_177230_c() instanceof TravelersBackpackBlock && worldIn.func_175625_s(backpackPos) instanceof TravelersBackpackTileEntity) {
            ((TravelersBackpackTileEntity)worldIn.func_175625_s(backpackPos)).setSleepingBagDeployed(false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SLEEPING_BAG;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, PART, OCCUPIED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.func_195593_d(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)state.func_177229_b((Property)field_185512_D), state.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return null;
    }
}

