/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTileEntityTypes;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TravelersBackpackBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape BACKPACK_SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)10.0, (double)12.0);
    private static final VoxelShape BACKPACK_SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)10.0, (double)12.0);
    private static final VoxelShape BACKPACK_SHAPE_EAST = Block.func_208617_a((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)10.0, (double)15.0);
    private static final VoxelShape BACKPACK_SHAPE_WEST = Block.func_208617_a((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)10.0, (double)15.0);

    public TravelersBackpackBlock(AbstractBlock.Properties builder) {
        super(builder.func_200948_a(1.0f, Float.MAX_VALUE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return BACKPACK_SHAPE_NORTH;
            }
            case SOUTH: {
                return BACKPACK_SHAPE_SOUTH;
            }
            case EAST: {
                return BACKPACK_SHAPE_EAST;
            }
            case WEST: {
                return BACKPACK_SHAPE_WEST;
            }
        }
        return BACKPACK_SHAPE_NORTH;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)worldIn.func_175625_s(pos);
            if (((Boolean)TravelersBackpackConfig.COMMON.enableBackpackBlockWearable.get()).booleanValue()) {
                if (player.func_225608_bj_() && !worldIn.field_72995_K) {
                    if (!CapabilityUtils.isWearingBackpack(player)) {
                        if (worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 7)) {
                            ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
                            te.transferToItemStack(stack);
                            CapabilityUtils.equipBackpack(player, stack);
                            if (te.isSleepingBagDeployed()) {
                                Direction bagDirection = (Direction)state.func_177229_b((Property)FACING);
                                worldIn.func_175656_a(pos.func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                worldIn.func_175656_a(pos.func_177972_a(bagDirection).func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("actions.equip_backpack.fail"), player.func_110124_au());
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("actions.equip_backpack.otherbackpack"), player.func_110124_au());
                    }
                } else {
                    te.openGUI(player, te, pos);
                }
            } else {
                te.openGUI(player, te, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TravelersBackpackTileEntity && !worldIn.func_201670_d()) {
            ((TravelersBackpackTileEntity)te).drop(worldIn, player, pos, this.func_199767_j());
            if (((TravelersBackpackTileEntity)te).isSleepingBagDeployed()) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                worldIn.func_175656_a(pos.func_177972_a(direction), Blocks.field_150350_a.func_176223_P());
                worldIn.func_175656_a(pos.func_177972_a(direction).func_177972_a(direction), Blocks.field_150350_a.func_176223_P());
            }
        }
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            te.transferToItemStack(stack);
        }
        return stack;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.TRAVELERS_BACKPACK.get()).func_200968_a();
    }
}

