/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public class TravelersBackpackInventory
implements IInventoryTravelersBackpack,
INamedContainerProvider {
    private FluidTank leftTank;
    private FluidTank rightTank;
    private NonNullList<ItemStack> inventory;
    private NonNullList<ItemStack> craftingGrid;
    private PlayerEntity player;
    private ItemStack stack;
    private int lastTime;
    private byte screenID;

    public TravelersBackpackInventory(ItemStack stack, PlayerEntity player, byte screenID) {
        this.leftTank = new FluidTank(((Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get()).intValue());
        this.rightTank = new FluidTank(((Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get()).intValue());
        this.inventory = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        this.craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.loadAllData(this.getTagCompound(stack));
    }

    @Override
    public NonNullList<ItemStack> getCraftingGridInventory() {
        return this.craftingGrid;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void func_70296_d() {
        this.saveAllData(this.getTagCompound(this.stack));
    }

    @Override
    public void markTankDirty() {
        this.saveTanks(this.getTagCompound(this.stack));
        this.sendPackets();
    }

    @Override
    public void saveAllData(CompoundNBT compound) {
        this.markTankDirty();
        this.saveItems(compound);
        this.saveTime(compound);
    }

    @Override
    public void loadAllData(CompoundNBT compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadTime(compound);
    }

    @Override
    public void saveTanks(CompoundNBT compound) {
        compound.func_218657_a("LeftTank", (INBT)this.leftTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("RightTank", (INBT)this.rightTank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    @Override
    public void saveItems(CompoundNBT compound) {
        ItemStackUtils.saveAllItemsBlackList(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void loadItems(CompoundNBT compound) {
        ItemStackUtils.loadAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void saveTime(CompoundNBT compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundNBT compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 50, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 52, this.player);
    }

    private void sendPackets() {
        if (this.screenID == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }

    @Override
    public CompoundNBT getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            CompoundNBT tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        return stack.func_77978_p();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public World getWorld() {
        return this.player.field_70170_p;
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent("InventoryTravelersBackpack");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? this.func_200200_C_() : this.func_200200_C_();
    }

    @Override
    public BlockPos getPosition() {
        return this.player.func_233580_cy_();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    public static void openGUI(ServerPlayerEntity serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)new TravelersBackpackInventory(stack, (PlayerEntity)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.func_150788_a(stack).writeByte((int)screenID));
        }
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new TravelersBackpackItemContainer(windowID, playerInventory, this);
    }
}

