/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.objects.style.HudStyleProvider;
import net.dark_roleplay.travellers_map.user_facing.huds.compass.CompassHud;
import net.dark_roleplay.travellers_map.user_facing.huds.minimap.MinimapHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ResourceReloadListener {
    private static final Gson GSON;

    public static void run() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new StyleReloadListener("travellers_map/minimap_styles", MinimapHUD.INSTANCE.getStyleProvider()));
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new StyleReloadListener("travellers_map/compass_styles", CompassHud.INSTANCE.getStyleProvider()));
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.excludeFieldsWithoutExposeAnnotation();
        GSON = builder.create();
    }

    private static class StyleReloadListener
    implements IFutureReloadListener {
        private HudStyleProvider styleProvider;
        private String folder;

        public StyleReloadListener(String folder, HudStyleProvider styleProvider) {
            this.folder = folder;
            this.styleProvider = styleProvider;
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.supplyAsync(() -> {
                HashSet<HudStyle> styles = new HashSet<HudStyle>();
                Collection minimapStyles = resourceManager.func_199003_a(this.folder, val -> val.endsWith(".json"));
                for (ResourceLocation styleLoc : minimapStyles) {
                    try {
                        IResource resource = resourceManager.func_199002_a(styleLoc);
                        try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(resource.func_199027_b())));){
                            HudStyle style = (HudStyle)GSON.fromJson(reader, HudStyle.class);
                            styles.add(style);
                        }
                        catch (JsonIOException | JsonSyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.styleProvider.reloadStyles(styles);
                return null;
            }).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
        }
    }
}

