/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.mapping;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.dark_roleplay.travellers_map.mapping.MapperQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.ChunkPos;

public class MappingHelper {
    private static final Set<MapperQueue> activeMappers = new HashSet<MapperQueue>();
    private static Timer chunkMapper;

    public static void initMapper() {
        if (chunkMapper != null) {
            return;
        }
        activeMappers.add(new MapperQueue());
        chunkMapper = new Timer("TravellersMap - Chunk Mapper", true);
        chunkMapper.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Minecraft.func_71410_x().field_71441_e == null) {
                    MappingHelper.killMapper();
                    return;
                }
                for (MapperQueue mapper : activeMappers) {
                    mapper.processLoadedChunksQueue();
                }
            }
        }, 250L, 250L);
        for (MapperQueue mapper : activeMappers) {
            mapper.initTimer(chunkMapper);
        }
    }

    public static void killMapper() {
        chunkMapper.cancel();
        chunkMapper = null;
        for (MapperQueue mapper : activeMappers) {
            mapper.stopMapper();
        }
        activeMappers.clear();
    }

    public static void scheduleLoadedChunk(ChunkPos pos) {
        for (MapperQueue mapper : activeMappers) {
            mapper.scheduleLoadedChunk(pos);
        }
    }

    public static void schedulePeriodicalChunk(ChunkPos pos) {
        for (MapperQueue mapper : activeMappers) {
            mapper.schedulePeriodicalChunk(pos);
        }
    }
}

