/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.color_palettes;

import net.dark_roleplay.travellers_map.objects.color_palettes.ColorPalette;
import net.minecraft.block.material.MaterialColor;

public class MonoColorPalette
extends ColorPalette {
    private int[][] colors;

    public MonoColorPalette(int colorMult) {
        int multR = colorMult >> 16 & 0xFF;
        int multG = colorMult >> 8 & 0xFF;
        int multB = colorMult & 0xFF;
        this.colors = new int[MaterialColor.field_76281_a.length][];
        for (int i = 0; i < MaterialColor.field_76281_a.length; ++i) {
            this.colors[i] = new int[4];
            for (int j = 0; j < 4; ++j) {
                if (MaterialColor.field_76281_a[i] == null) continue;
                int color = MaterialColor.field_76281_a[i].func_151643_b(j);
                float red = color >> 16 & 0xFF;
                float green = color >> 8 & 0xFF;
                float blue = color & 0xFF;
                int grayColor = (int)(0.21 * (double)red + 0.72 * (double)green + 0.07 * (double)blue);
                int redChannel = (int)((float)grayColor * ((float)multR / 256.0f)) << 16;
                int greenChannel = (int)((float)grayColor * ((float)multG / 256.0f)) << 8;
                int blueChannel = (int)((float)grayColor * ((float)multB / 256.0f));
                this.colors[i][j] = 0xFF000000 | redChannel | greenChannel | blueChannel;
            }
        }
    }

    @Override
    public int getRGBA(int colorIndex, int shading) {
        if (colorIndex >= this.colors.length || shading > 3) {
            return 0;
        }
        return this.colors[colorIndex][shading];
    }
}

