/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.map_layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dark_roleplay.travellers_map.rendering.IMapLayer;
import net.dark_roleplay.travellers_map.rendering.MapRenderInfo;
import net.dark_roleplay.travellers_map.rendering.MapType;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class WaypointLayer
extends IMapLayer {
    private static ResourceLocation WAYPOINT_ICONS = new ResourceLocation("travellers_map", "textures/guis/waypoint_icons.png");

    public WaypointLayer() {
        super(true);
    }

    @Override
    public void renderLayer(MatrixStack matrix, MapRenderInfo renderInfo, MapType mapType, boolean isRotated, float delta) {
        float posX = renderInfo.getCenterX() - (float)(renderInfo.getScaledWidth() / 2) - 10.0f;
        float posX2 = renderInfo.getCenterX() + (float)(renderInfo.getScaledWidth() / 2) + 10.0f;
        float posZ = renderInfo.getCenterZ() - (float)(renderInfo.getScaledHeight() / 2) - 10.0f;
        float posZ2 = renderInfo.getCenterZ() + (float)(renderInfo.getScaledHeight() / 2) + 10.0f;
        MapManager.WAYPOINTS.stream().filter(waypoint -> waypoint.isVisible()).filter(waypoint -> (float)waypoint.getPos().func_177958_n() > posX && (float)waypoint.getPos().func_177958_n() < posX2 && (float)waypoint.getPos().func_177952_p() > posZ && (float)waypoint.getPos().func_177952_p() < posZ2).forEach(waypoint -> {
            double waypointX = (float)waypoint.getPos().func_177958_n() - renderInfo.getCenterX();
            double waypointZ = (float)waypoint.getPos().func_177952_p() - renderInfo.getCenterZ();
            boolean isHovered = this.isHovered(renderInfo, waypointX, waypointZ);
            matrix.func_227860_a_();
            matrix.func_227861_a_(waypointX, waypointZ, 0.0);
            if (isRotated) {
                float yaw = (float)Math.toRadians(Minecraft.func_71410_x().field_71439_g.func_195046_g(delta) - 180.0f) / 2.0f;
                matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)Math.sin(yaw), (float)Math.cos(yaw)));
            }
            RenderSystem.color3f((float)1.0f, (float)0.0f, (float)0.0f);
            if (isHovered) {
                RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.8f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WAYPOINT_ICONS);
            WaypointLayer.func_238466_a_((MatrixStack)matrix, (int)-3, (int)-11, (int)7, (int)12, (float)0.0f, (float)12.0f, (int)7, (int)12, (int)140, (int)120);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            matrix.func_227861_a_(-waypointX - (double)(renderInfo.getScaledWidth() / 2), -waypointZ - (double)(renderInfo.getScaledHeight() / 2), 0.0);
            matrix.func_227865_b_();
        });
    }

    private boolean isHovered(MapRenderInfo renderInfo, double waypointX, double waypointZ) {
        if (!renderInfo.hasMouse()) {
            return false;
        }
        return waypointX - 1.0 < renderInfo.getScaledMouseX() && waypointX + 2.0 > renderInfo.getScaledMouseX() && waypointZ - 9.0 < renderInfo.getScaledMouseY() && waypointZ > renderInfo.getScaledMouseY();
    }
}

