/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.mappers;

import net.dark_roleplay.travellers_map.mapping.Mapper;
import net.dark_roleplay.travellers_map.objects.color_palettes.ColorPalette;
import net.dark_roleplay.travellers_map.objects.color_palettes.DefaultColorPalette;
import net.dark_roleplay.travellers_map.util.MapperUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;

public class CaveColorMapper
extends Mapper {
    public static Mapper INSTANCE = new CaveColorMapper(new DefaultColorPalette());
    private ColorPalette palette;
    private static int height = 96;

    public CaveColorMapper(ColorPalette palette) {
        this.palette = palette;
    }

    @Override
    public void mapChunk(World world, IChunk chunk, NativeImage img) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos.Mutable worker = new BlockPos.Mutable();
        int x = chunkPos.field_77276_a * 16;
        int z = chunkPos.field_77275_b * 16;
        int i = 0;
        int x2 = x;
        while (i < 16) {
            int j = 0;
            int z2 = z;
            while (j < 16) {
                BlockState firstBlock = MapperUtil.getFirstMappableBlock(world, pos.func_181079_c(x2, height, z2), height, 0);
                if (firstBlock != null) {
                    MaterialColor color = firstBlock.func_185909_g((IBlockReader)world, (BlockPos)pos);
                    if (color != null && (pos.func_177956_o() < height || this.isVisible(chunk, (BlockPos)pos, worker))) {
                        int brightness = 1;
                        if (world.func_180495_p(pos.func_177982_a(0, 1, -1)).func_185909_g((IBlockReader)world, (BlockPos)pos) != MaterialColor.field_151660_b) {
                            --brightness;
                        }
                        if (world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_185909_g((IBlockReader)world, (BlockPos)pos) == MaterialColor.field_151660_b) {
                            ++brightness;
                        }
                        float light = 0.04f * (float)world.func_201696_r(pos.func_177982_a(0, 1, 0)) + 0.4f;
                        int argb = this.palette.getRGBA(color.field_76290_q, brightness);
                        int red = (int)((float)(argb >> 16 & 0xFF) * light);
                        int green = (int)((float)(argb >> 8 & 0xFF) * light);
                        int blue = (int)((float)(argb & 0xFF) * light);
                        img.func_195700_a(Math.floorMod(x2, 512), Math.floorMod(z2, 512), argb & 0xFF000000 | red << 16 | green << 8 | blue);
                    } else {
                        img.func_195700_a(Math.floorMod(x2, 512), Math.floorMod(z2, 512), -16777216);
                    }
                }
                ++j;
                ++z2;
            }
            ++i;
            ++x2;
        }
    }

    @Override
    public int getMappingInterval() {
        return 1000;
    }

    @Override
    public int getMaxChunksPerRun() {
        return 10;
    }

    @Override
    public boolean canMapChunk(World world, IChunk chunk) {
        return world.func_217353_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b - 1, ChunkStatus.field_222617_m, false) != null && world.func_217353_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b + 1, ChunkStatus.field_222617_m, false) != null && world.func_217353_a(chunk.func_76632_l().field_77276_a - 1, chunk.func_76632_l().field_77275_b, ChunkStatus.field_222617_m, false) != null && world.func_217353_a(chunk.func_76632_l().field_77276_a + 1, chunk.func_76632_l().field_77275_b, ChunkStatus.field_222617_m, false) != null;
    }

    private boolean isVisible(IChunk chunk, BlockPos center, BlockPos.Mutable worker) {
        if (chunk.func_180495_p((BlockPos)worker.func_181079_c(center.func_177958_n(), center.func_177956_o(), center.func_177952_p() - 1)).func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)worker) == MaterialColor.field_151660_b) {
            return true;
        }
        if (chunk.func_180495_p((BlockPos)worker.func_181079_c(center.func_177958_n() - 1, center.func_177956_o(), center.func_177952_p())).func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)worker) == MaterialColor.field_151660_b) {
            return true;
        }
        if (chunk.func_180495_p((BlockPos)worker.func_181079_c(center.func_177958_n(), center.func_177956_o(), center.func_177952_p() + 1)).func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)worker) == MaterialColor.field_151660_b) {
            return true;
        }
        return chunk.func_180495_p((BlockPos)worker.func_181079_c(center.func_177958_n() + 1, center.func_177956_o(), center.func_177952_p())).func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)worker) == MaterialColor.field_151660_b;
    }
}

