/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.mappers;

import net.dark_roleplay.travellers_map.mapping.Mapper;
import net.dark_roleplay.travellers_map.objects.color_palettes.ColorPalette;
import net.dark_roleplay.travellers_map.objects.color_palettes.DefaultColorPalette;
import net.dark_roleplay.travellers_map.objects.color_palettes.MonoColorPalette;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class FlatColorMapper
extends Mapper {
    public static Mapper INSTANCE_COLOR = new FlatColorMapper(new DefaultColorPalette());
    public static Mapper INSTANCE_GRAYSCALE = new FlatColorMapper(new MonoColorPalette(-1));
    private ColorPalette palette;

    public FlatColorMapper(ColorPalette palette) {
        this.palette = palette;
    }

    @Override
    public void mapChunk(World world, IChunk chunk, NativeImage img) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int x = Math.floorMod(chunk.func_76632_l().field_77276_a, 32) * 16;
        int z = Math.floorMod(chunk.func_76632_l().field_77275_b, 32) * 16;
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                int y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x2, z2);
                BlockState state = chunk.func_180495_p((BlockPos)pos.func_181079_c(x2, y, z2));
                MaterialColor color = state.func_185909_g((IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)pos);
                if (color == null) continue;
                img.func_195700_a(x + x2, z + z2, this.palette.getRGBA(color.field_76290_q));
            }
        }
    }

    @Override
    public int getMappingInterval() {
        return 1000;
    }

    @Override
    public int getMaxChunksPerRun() {
        return 40;
    }
}

