/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.mappers;

import net.dark_roleplay.travellers_map.mapping.Mapper;
import net.dark_roleplay.travellers_map.objects.color_palettes.ColorPalette;
import net.dark_roleplay.travellers_map.objects.color_palettes.DefaultColorPalette;
import net.dark_roleplay.travellers_map.objects.color_palettes.MonoColorPalette;
import net.dark_roleplay.travellers_map.util.MapperUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class LightingColorMapper
extends Mapper {
    public static Mapper INSTANCE = new LightingColorMapper(new DefaultColorPalette());
    public static Mapper INSTANCE_GRAYSCALE = new LightingColorMapper(new MonoColorPalette(-1));
    private ColorPalette palette;

    public LightingColorMapper(ColorPalette palette) {
        this.palette = palette;
    }

    @Override
    public void mapChunk(World world, IChunk chunk, NativeImage img) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos.Mutable fluidPos = new BlockPos.Mutable();
        int x = chunkPos.field_77276_a * 16;
        int z = chunkPos.field_77275_b * 16;
        int i = 0;
        int x2 = x;
        while (i < 16) {
            int j = 0;
            int z2 = z;
            while (j < 16) {
                MaterialColor color;
                int y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x2, z2);
                BlockState firstBlock = MapperUtil.getFirstMappableBlock(world, pos.func_181079_c(x2, y, z2), y, 0);
                if (firstBlock != null && (color = firstBlock.func_185909_g((IBlockReader)world, (BlockPos)pos)) != null) {
                    int brightness;
                    if (!firstBlock.func_204520_s().func_206888_e() && firstBlock.func_204520_s().func_206886_c() == Fluids.field_204546_a) {
                        brightness = 2;
                        boolean isPrimary = (i + j) % 2 == 1;
                        int depth = MapperUtil.getFluidDepth(world, fluidPos.func_189533_g((Vector3i)pos));
                        if (depth >= 10 || depth >= 7 && isPrimary) {
                            brightness = 0;
                        } else if (depth >= 5 || depth >= 3 && isPrimary) {
                            brightness = 1;
                        }
                    } else {
                        brightness = 1;
                        if (world.func_180495_p(pos.func_177982_a(0, 1, -1)).func_185909_g((IBlockReader)world, (BlockPos)pos) != MaterialColor.field_151660_b) {
                            --brightness;
                        }
                        if (world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_185909_g((IBlockReader)world, (BlockPos)pos) == MaterialColor.field_151660_b) {
                            ++brightness;
                        }
                    }
                    img.func_195700_a(Math.floorMod(x2, 512), Math.floorMod(z2, 512), this.palette.getRGBA(color.field_76290_q, brightness));
                }
                ++j;
                ++z2;
            }
            ++i;
            ++x2;
        }
    }

    @Override
    public int getMappingInterval() {
        return 1000;
    }

    @Override
    public int getMaxChunksPerRun() {
        return 20;
    }

    @Override
    public boolean canMapChunk(World world, IChunk chunk) {
        return world.func_217353_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b - 1, ChunkStatus.field_222617_m, false) != null;
    }
}

