/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.style;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.dark_roleplay.travellers_map.configs.client.HudConfig;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;

public class HudStyleProvider {
    private final Map<String, HudStyle> styles;
    private final HudStyle fallbackStyle;
    private final HudConfig config;
    private HudStyle activeStyle;

    public HudStyleProvider(HudConfig config, HudStyle fallbackStyle) {
        this.config = config;
        this.fallbackStyle = fallbackStyle;
        this.styles = new HashMap<String, HudStyle>();
    }

    public HudStyle getActiveStyle() {
        return this.activeStyle == null ? this.fallbackStyle : this.activeStyle;
    }

    public void setActiveStyle(HudStyle newStyle) {
        this.activeStyle = newStyle;
        this.config.STYLE.set((Object)newStyle.getStyleName());
    }

    public void reloadStyles(Set<HudStyle> styles) {
        this.styles.clear();
        this.styles.put(this.fallbackStyle.getStyleName(), this.fallbackStyle);
        for (HudStyle style : styles) {
            this.styles.put(style.getStyleName(), style);
        }
        this.activeStyle = this.styles.get(this.config.STYLE.get());
    }

    public Collection<HudStyle> getStyles() {
        return this.styles.values();
    }
}

