/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.objects.waypoints;

import java.util.UUID;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class Waypoint
implements INBTSerializable<CompoundNBT> {
    public final UUID uuid;
    private String name;
    private BlockPos pos;
    private int color;
    private boolean isVisible;
    public static int widestNameWidth = 0;
    private float lastRenderedYaw;
    private float lastRenderedOffset;
    private int nameWidth;

    public Waypoint(UUID uuid) {
        this.uuid = uuid;
    }

    public Waypoint(UUID uuid, String name, BlockPos pos, int color, boolean isVisible) {
        this(uuid);
        this.name = name;
        this.pos = pos;
        this.color = color;
        this.isVisible = true;
    }

    public void update(String newName, BlockPos newPos, int newColor) {
        this.name = newName;
        this.pos = newPos;
        this.color = newColor;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void toggleVisible() {
        this.isVisible = !this.isVisible;
        MapManager.saveWaypoint(this, false);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        nbt.func_74757_a("enabled", this.isVisible);
        nbt.func_74768_a("color", this.color);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.name = nbt.func_74779_i("name");
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
        this.isVisible = nbt.func_74767_n("enabled");
        this.color = nbt.func_74762_e("color");
    }

    public Waypoint setLastRenderedData(float lastRenderedYaw, float lastRenderedOffset) {
        this.lastRenderedYaw = lastRenderedYaw;
        this.lastRenderedOffset = lastRenderedOffset;
        return this;
    }

    public Waypoint initNameWidth(FontRenderer renderer) {
        this.nameWidth = renderer.func_78256_a(this.name);
        if (this.nameWidth > widestNameWidth) {
            widestNameWidth = this.nameWidth;
        }
        return this;
    }

    public float getLastRenderedYaw() {
        return this.lastRenderedYaw;
    }

    public float getLastRenderedOffset() {
        return this.lastRenderedOffset;
    }

    public int getNameWidth() {
        return this.nameWidth;
    }
}

