/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.rendering;

import net.minecraft.util.math.BlockPos;

public class MapRenderInfo {
    private int width;
    private int height;
    private int scaledWidth;
    private int scaledHeight;
    private int offsetX;
    private int offsetZ;
    private float scale;
    private float centerX;
    private float centerZ;
    private Long[][] segments;
    private boolean hasMouse;
    private double mouseX;
    private double mouseY;
    private double scaledMouseX;
    private double scaledMouseY;

    public void update(int width, int height, double scale, BlockPos center, double mouseX, double mouseY) {
        this.update(width, height, scale, center);
        this.hasMouse = true;
        this.mouseX = mouseX - (double)((float)width / 2.0f);
        this.mouseY = mouseY - (double)((float)height / 2.0f);
        this.scaledMouseX = this.mouseX / (double)this.scale;
        this.scaledMouseY = this.mouseY / (double)this.scale;
    }

    public void update(int width, int height, double scale, BlockPos center) {
        this.hasMouse = false;
        this.width = width;
        this.height = height;
        this.scale = (float)scale;
        this.scaledWidth = (int)((float)width / this.scale) + 2;
        this.scaledHeight = (int)((float)height / this.scale) + 2;
        this.centerX = center.func_177958_n();
        this.centerZ = center.func_177952_p();
        int minSegX = center.func_177958_n() - this.scaledWidth >> 9;
        int minSegZ = center.func_177952_p() - this.scaledHeight >> 9;
        int maxSegX = center.func_177958_n() + this.scaledWidth >> 9;
        int maxSegZ = center.func_177952_p() + this.scaledHeight >> 9;
        this.offsetX = -(center.func_177958_n() - minSegX * 512);
        this.offsetZ = -(center.func_177952_p() - minSegZ * 512);
        this.segments = new Long[maxSegX - minSegX + 1][maxSegZ - minSegZ + 1];
        for (int x = 0; x <= maxSegX - minSegX; ++x) {
            for (int z = 0; z <= maxSegZ - minSegZ; ++z) {
                this.segments[x][z] = ((long)(minSegX + x) & 0xFFFFFFFFL) << 32 | (long)(minSegZ + z) & 0xFFFFFFFFL;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public float getScale() {
        return this.scale;
    }

    public Long[][] getSegments() {
        return this.segments;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public boolean hasMouse() {
        return this.hasMouse;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public double getScaledMouseX() {
        return this.scaledMouseX;
    }

    public double getScaledMouseY() {
        return this.scaledMouseY;
    }
}

