/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.dark_roleplay.travellers_map.objects.map_layers.MapLayer;
import net.dark_roleplay.travellers_map.objects.map_layers.PlayerMarkerLayer;
import net.dark_roleplay.travellers_map.objects.map_layers.WaypointLayer;
import net.dark_roleplay.travellers_map.rendering.IMapLayer;
import net.dark_roleplay.travellers_map.rendering.MapRenderInfo;
import net.dark_roleplay.travellers_map.rendering.MapType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.vector.Quaternion;

public class MapRenderer {
    private static List<IMapLayer> mapLayers = new ArrayList<IMapLayer>();

    public static void renderMap(MatrixStack matrix, MapRenderInfo renderInfo, MapType mapType, boolean rotate, float delta) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)((float)renderInfo.getWidth() / 2.0f), (double)((float)renderInfo.getHeight() / 2.0f), 0.0);
        matrix.func_227862_a_(renderInfo.getScale(), renderInfo.getScale(), renderInfo.getScale());
        if (rotate) {
            float yaw = -((float)Math.toRadians(Minecraft.func_71410_x().field_71439_g.func_195046_g(delta) - 180.0f)) / 2.0f;
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)Math.sin(yaw), (float)Math.cos(yaw)));
        }
        mapLayers.stream().filter(layer -> layer.isEnabled() && layer.canRenderIn(mapType)).forEachOrdered(layer -> layer.renderLayer(matrix, renderInfo, mapType, rotate, delta));
        matrix.func_227865_b_();
    }

    static {
        mapLayers.add(new MapLayer());
        mapLayers.add(new PlayerMarkerLayer());
        mapLayers.add(new WaypointLayer());
    }
}

