/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.travellers_map.user_facing.huds.compass;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dark_roleplay.travellers_map.configs.ClientConfig;
import net.dark_roleplay.travellers_map.objects.style.HudStyle;
import net.dark_roleplay.travellers_map.objects.style.HudStyleProvider;
import net.dark_roleplay.travellers_map.objects.waypoints.Waypoint;
import net.dark_roleplay.travellers_map.user_facing.huds.hud.Hud;
import net.dark_roleplay.travellers_map.util.BlendBlitHelper;
import net.dark_roleplay.travellers_map.util.MapManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class CompassHud
extends Hud {
    public static final CompassHud INSTANCE = new CompassHud();
    private static ResourceLocation WAYPOINT_ICONS = new ResourceLocation("travellers_map", "textures/guis/waypoint_icons.png");
    private static final int HALF_WIDTH = 128;
    private float playerYaw;
    private Vector3d playerPos;
    private int renderedNames = 0;

    private CompassHud() {
        super(ClientConfig.COMPASS, "hud.travellers_map.compass", new HudStyleProvider(ClientConfig.COMPASS, new HudStyle("Default", 256, 16, "travellers_map:textures/styles/compass/default_mask.png", "travellers_map:textures/styles/compass/default_overlay.png")));
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, float delta) {
        HudStyle style = this.getStyleProvider().getActiveStyle();
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)((Double)ClientConfig.COMPASS.SCALE.get()), (double)((Double)ClientConfig.COMPASS.SCALE.get()), (double)1.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(style.getOverlay());
        BlendBlitHelper.blit(0.0, 0.0, 256, 16, 0.0f, 0.0f, 1, 1, 1, 1);
        this.resetMarkerRendering(delta);
        this.drawDirectionMarker(matrix, 0.0f, "S");
        this.drawDirectionMarker(matrix, 90.0f, "W");
        this.drawDirectionMarker(matrix, 180.0f, "N");
        this.drawDirectionMarker(matrix, 270.0f, "E");
        RenderSystem.disableBlend();
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        for (Waypoint waypoint : MapManager.WAYPOINTS) {
            if (!waypoint.isVisible()) continue;
            float waypointYaw = this.getYawForMarker(waypoint.getPos());
            float waypointOffset = (waypointYaw - this.playerYaw) / 90.0f * 128.0f;
            waypoint.setLastRenderedData(waypointYaw, waypointOffset);
            if (waypoint.getLastRenderedOffset() < -128.0f || waypoint.getLastRenderedOffset() > 128.0f) continue;
            this.drawWaypointMarker(matrix, waypoint);
            if (!(waypoint.getLastRenderedYaw() - 3.0f < this.playerYaw) || !(waypoint.getLastRenderedYaw() + 3.0f > this.playerYaw)) continue;
            waypoint.initNameWidth(renderer);
        }
        for (Waypoint waypoint : MapManager.WAYPOINTS) {
            if (!waypoint.isVisible() || !(waypoint.getLastRenderedYaw() - 3.0f < this.playerYaw) || !(waypoint.getLastRenderedYaw() + 3.0f > this.playerYaw)) continue;
            this.drawWaypointName(matrix, renderer, waypoint);
        }
        RenderSystem.popMatrix();
    }

    private void resetMarkerRendering(float delta) {
        this.playerYaw = Math.floorMod((int)Minecraft.func_71410_x().field_71439_g.func_195046_g(delta), 360);
        this.playerPos = Minecraft.func_71410_x().field_71439_g.func_213303_ch();
        this.renderedNames = 0;
        Waypoint.widestNameWidth = 0;
    }

    private Waypoint drawWaypointMarker(MatrixStack matrix, Waypoint waypoint) {
        RenderSystem.enableAlphaTest();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WAYPOINT_ICONS);
        float pos = 128.0f + waypoint.getLastRenderedOffset() - 3.5f;
        BlendBlitHelper.blitColor(pos, 2.0, 7, 12, 0.0f, 0.0f, 7, 12, 140, 120, waypoint.getColor());
        return waypoint;
    }

    private void drawWaypointName(MatrixStack matrix, FontRenderer renderer, Waypoint waypoint) {
        CompassHud.func_238467_a_((MatrixStack)matrix, (int)(128 - Waypoint.widestNameWidth / 2 - 2), (int)(16 + this.renderedNames * 10), (int)(128 + Waypoint.widestNameWidth / 2 + 2), (int)(26 + this.renderedNames * 10), (int)-1607257293);
        renderer.func_238405_a_(matrix, waypoint.getName(), (float)(128 - renderer.func_78256_a(waypoint.getName()) / 2), (float)(17 + this.renderedNames * 10), waypoint.getColor());
        ++this.renderedNames;
    }

    private void drawDirectionMarker(MatrixStack matrix, float markerYaw, String markerName) {
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        if (markerYaw > 270.0f && this.playerYaw < 180.0f) {
            markerYaw -= 360.0f;
        } else if (markerYaw < 90.0f && this.playerYaw > 180.0f) {
            markerYaw += 360.0f;
        }
        float offset = (markerYaw - this.playerYaw) / 90.0f * 128.0f;
        if (offset > -128.0f && offset < 128.0f) {
            float pos = 128.0f + offset;
            BlendBlitHelper.vLine(pos - 1.0f, 2.0f, 3.5f, -7829368);
            BlendBlitHelper.vLine(pos - 1.0f, 12.5f, 14.0f, -7829368);
            renderer.func_238405_a_(matrix, markerName, pos - (float)(renderer.func_78256_a(markerName) / 2), 4.5f, -7829368);
        }
    }

    private float getYawForMarker(BlockPos pos) {
        Vector3d pos2 = new Vector3d((double)pos.func_177958_n() - this.playerPos.func_82615_a(), 0.0, (double)pos.func_177952_p() - this.playerPos.func_82616_c());
        float angle = (float)Math.toDegrees(Math.atan2(Math.abs(pos2.func_82615_a()), -pos2.func_82616_c()));
        if (pos2.func_82615_a() < 0.0) {
            angle = 360.0f - angle;
        }
        if ((angle = (angle + 180.0f) % 360.0f) > 270.0f && this.playerYaw < 180.0f) {
            angle -= 360.0f;
        } else if (angle < 90.0f && this.playerYaw > 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

